package com.devplatform.equipment.modules.liresource.service.impl;

import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.dao.LiResourceDao;
import com.devplatform.equipment.modules.liresource.model.LiResourceModel;
import com.devplatform.equipment.modules.liresource.service.LiResourceService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

/**
 * 资源点管理表的service接口实现类 <br>
 * <b>功能：</b>LiResourceServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("liResourceService")
public class LiResourceServiceImpl extends MyBaseServiceImpl<LiResourceDao, LiResource>
    implements LiResourceService {
  @Override
  public List<LiResource> queryPageByList(LiResourceModel model) {
    Integer rowCount = baseMapper.queryPageByCount(model);
    model.getPager().setRowCount(rowCount);
    return baseMapper.queryPageByList(model);
  }

  @Override
  public void deleteByIds(List<String> list) {
    if (list != null && list.size() > 0) {
      baseMapper.deleteByIds(list);
    }
  }

  @Override
  public List<LiResource> getTreeList(LiResourceModel model) {
    return baseMapper.getTreeList(model);
  }

  @Override
  public LiResource getBeanById(String id) {
    return baseMapper.getBeanById(id);
  }

  @Override
  public List<LiResource> getByIds(List<String> ids) {
    return baseMapper.getByIds(ids);
  }

  @Override
  public List<LiResource> getTreeListByModel(LiResourceModel resourceModel) {
    return baseMapper.getTreeListByModel(resourceModel);
  }

  @Override
  public List<String> getAllResourceNameList(LiResourceModel model) {
    return baseMapper.getAllResourceNameList(model);
  }

  @Override
  public List<LiResource> getNormalByIds(ArrayList<String> ids) {
    return baseMapper.getNormalByIds(ids);
  }

  @Override
  public List<LiResource> queryByEnshrine(LiResourceModel lrm) {
    return baseMapper.queryByEnshrine(lrm);
  }

  @Override
  public List<LiResource> queryByDefenceId(String id) {
    return baseMapper.queryByDefenceId(id);
  }

  @Override
  public List<LiResource> queryByParent(String id) {
    return baseMapper.queryByParent(id);
  }

  @Override
  public List<LiResource> getAllEq(String stationId, String subCode) {
    return baseMapper.getAllEq(stationId, subCode);
  }

  @Override
  public String getOrderNumByResId(String id) {
    return baseMapper.getOrderNumByResId(id);
  }

  @Override
  public LiResource queryById(String id) {
    return baseMapper.queryById(id);
  }
}
