package com.devplatform.equipment.modules.liresourcecamera.controller;

import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.liresourcecamera.bean.LiResourceCamera;
import com.devplatform.equipment.modules.liresourcecamera.service.LiResourceCameraService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"资源点与摄像头关联表接口"})
@RestController
@RequestMapping("/liResourceCamera")
public class LiResourceCameraController extends AbstractController {

  @Autowired private LiResourceCameraService liResourceCameraService;

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取资源点与摄像头关联表分页数据列表", notes = "根据条件获取资源点与摄像头关联表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = liResourceCameraService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 根据ID获取资源点与摄像头关联表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取资源点与摄像头关联表对象", notes = "根据ID获取资源点与摄像头关联表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LiResourceCamera bean = liResourceCameraService.getById(id);
    return R.ok().put("bean", bean);
  }
}
