package com.devplatform.equipment.modules.liresourcecamera.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.liresourcecamera.bean.LiResourceCamera;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * LiResourceCamera Mapper 用于资源点与摄像头关联表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LiResourceCameraDao extends MyBaseMapper<LiResourceCamera> {

  /**
   * 根据资源点id查询资源点关联摄像头
   * @param resourceId
   * @return
   */
  List<LiResourceCamera> getByResourceId(String resourceId);
}
