package com.devplatform.equipment.modules.listation.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;

/**
 * @author Administrator
 */
@ApiModel(value = "线路站点管理表对象", description = "线路站点管理表对象")
@TableName("li_station")
public class LiStation implements Serializable {
  /** */
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "主键ID", name = "id")
  @TableId
	/** 主键id*/
  private String id; 

  @ApiModelProperty(value = "线路表id", name = "lineId")
	/** 线路表id*/
  private String lineId; 

  @ApiModelProperty(value = "线路名称", name = "lineName")
	/** 线路名称*/
  private String lineName; 

  @ApiModelProperty(value = "车站名称", name = "stationName")
	/** 车站名称*/
  private String stationName; 

  @ApiModelProperty(value = "车站编号", name = "code")
	/** 车站编号*/
  private String code; 

  @ApiModelProperty(value = "简称", name = "shortName")
	/** 简称*/
  private String shortName; 

  @ApiModelProperty(value = "地图X坐标", name = "x")
	/** 地图X坐标*/
  private String x; 

  @ApiModelProperty(value = "地图y坐标", name = "y")
	/** 地图y坐标*/
  private String y; 

  @ApiModelProperty(value = "位置", name = "location")
	/** 位置*/
  private String location; 

  @ApiModelProperty(value = "图标地址", name = "icon")
	/** 图标地址*/
  private String icon; 

  @ApiModelProperty(value = "站点类型(1正线车站，2换乘车站)", name = "type")
	/** 站点类型(1正线车站，2换乘车站)*/
  private String type; 

  @ApiModelProperty(value = "站点描述", name = "remark")
	/** 站点描述*/
  private String remark; 

  @ApiModelProperty(value = "是否主站(1主站，2从站)", name = "isMaster")
	/** 是否主站(1主站，2从站)*/
  private Integer isMaster; 

  @ApiModelProperty(value = "排序值", name = "orderNum")
	/** 排序值*/
  private Integer orderNum; 

  @ApiModelProperty(value = "系统标识", name = "sysSign")
	/** 系统标识*/
  private String sysSign; 

  @ApiModelProperty(value = "状态(1正常，0不可用)", name = "status")
	/** 状态(1正常，0不可用)*/
  private Integer status; 

  @ApiModelProperty(value = "是否已删除（0未删除，1已删除）", name = "deleted")
	/** 是否已删除（0未删除，1已删除）*/
  private Integer deleted; 

  @ApiModelProperty(value = "创建人", name = "createUserId")
	/** 创建人*/
  private String createUserId; 

  @ApiModelProperty(value = "创建时间", name = "createTime")
	/** 创建时间*/
  private java.util.Date createTime; 

  @ApiModelProperty(value = "修改人", name = "updateUserId")
	/** 修改人*/
  private String updateUserId; 

  @ApiModelProperty(value = "修改时间", name = "updateTime")
	/** 修改时间*/
  private java.util.Date updateTime; 

  @ApiModelProperty(value = "备用项1", name = "byx1")
	/** 备用项1*/
  private String byx1; 

  @ApiModelProperty(value = "备用项2", name = "byx2")
	/** 备用项2*/
  private String byx2; 

  @ApiModelProperty(value = "备用项3", name = "byx3")
	/** 备用项3*/
  private String byx3; 


  @ApiModelProperty(value = "地铁线路图横坐标", name = "coordinateX")
	/** 地铁线路图横坐标*/
  private Integer coordinateX; 

  @ApiModelProperty(value = "地铁线路图纵坐标", name = "coordinateY")
	/** 地铁线路图纵坐标*/
  private Integer coordinateY; 

  @ApiModelProperty(value = "地铁线路图站点名称显示位置(1上，2下，3左，4右)", name = "textPosition")
	/** 地铁线路图站点名称显示位置(1上，2下，3左，4右)*/
  private Integer textPosition; 

  @ApiModelProperty(value = "地铁线路图线路颜色", name = "lineColor")
	/** 地铁线路图线路颜色*/
  private String lineColor; 

  @ApiModelProperty(value = "地铁线路编号", name = "lineCode")
	/** 地铁线路编号*/
  private String lineCode; 

  @TableField(exist = false)
	/** 站点地图*/
  private List<LiStationMap> mapList; 

  public List<LiStationMap> getMapList() {
    return mapList;
  }

  public void setMapList(List<LiStationMap> mapList) {
    this.mapList = mapList;
  }

  public String getX() {
    return x;
  }

  public void setX(String x) {
    this.x = x;
  }

  public String getY() {
    return y;
  }

  public void setY(String y) {
    this.y = y;
  }

  public String getLocation() {
    return location;
  }

  public void setLocation(String location) {
    this.location = location;
  }

  public String getIcon() {
    return icon;
  }

  public void setIcon(String icon) {
    this.icon = icon;
  }

  /** 主键id的getter方法 */
  public String getId() {
    return id;
  }
  /** 主键id的setter方法 */
  public void setId(String id) {
    this.id = id;
  }
  /** 线路表id的getter方法 */
  public String getLineId() {
    return lineId;
  }
  /** 线路表id的setter方法 */
  public void setLineId(String lineId) {
    this.lineId = lineId;
  }
  /** 线路名称的getter方法 */
  public String getLineName() {
    return lineName;
  }
  /** 线路名称的setter方法 */
  public void setLineName(String lineName) {
    this.lineName = lineName;
  }
  /** 车站名称的getter方法 */
  public String getStationName() {
    return stationName;
  }
  /** 车站名称的setter方法 */
  public void setStationName(String stationName) {
    this.stationName = stationName;
  }
  /** 车站编号的getter方法 */
  public String getCode() {
    return code;
  }
  /** 车站编号的setter方法 */
  public void setCode(String code) {
    this.code = code;
  }
  /** 简称的getter方法 */
  public String getShortName() {
    return shortName;
  }
  /** 简称的setter方法 */
  public void setShortName(String shortName) {
    this.shortName = shortName;
  }
  /** 站点类型(1正线车站，2换乘车站)的getter方法 */
  public String getType() {
    return type;
  }
  /** 站点类型(1正线车站，2换乘车站)的setter方法 */
  public void setType(String type) {
    this.type = type;
  }
  /** 站点描述的getter方法 */
  public String getRemark() {
    return remark;
  }
  /** 站点描述的setter方法 */
  public void setRemark(String remark) {
    this.remark = remark;
  }

  public Integer getIsMaster() {
    return isMaster;
  }

  public void setIsMaster(Integer isMaster) {
    this.isMaster = isMaster;
  }

  /** 排序值的getter方法 */
  public Integer getOrderNum() {
    return orderNum;
  }
  /** 排序值的setter方法 */
  public void setOrderNum(Integer orderNum) {
    this.orderNum = orderNum;
  }
  /** 系统标识的getter方法 */
  public String getSysSign() {
    return sysSign;
  }
  /** 系统标识的setter方法 */
  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }
  /** 状态(1正常，0不可用)的getter方法 */
  public Integer getStatus() {
    return status;
  }
  /** 状态(1正常，0不可用)的setter方法 */
  public void setStatus(Integer status) {
    this.status = status;
  }
  /** 是否已删除（0未删除，1已删除）的getter方法 */
  public Integer getDeleted() {
    return deleted;
  }
  /** 是否已删除（0未删除，1已删除）的setter方法 */
  public void setDeleted(Integer deleted) {
    this.deleted = deleted;
  }
  /** 创建人的getter方法 */
  public String getCreateUserId() {
    return createUserId;
  }
  /** 创建人的setter方法 */
  public void setCreateUserId(String createUserId) {
    this.createUserId = createUserId;
  }
  /** 创建时间的getter方法 */
  public java.util.Date getCreateTime() {
    return createTime;
  }
  /** 创建时间的setter方法 */
  public void setCreateTime(java.util.Date createTime) {
    this.createTime = createTime;
  }
  /** 修改人的getter方法 */
  public String getUpdateUserId() {
    return updateUserId;
  }
  /** 修改人的setter方法 */
  public void setUpdateUserId(String updateUserId) {
    this.updateUserId = updateUserId;
  }
  /** 修改时间的getter方法 */
  public java.util.Date getUpdateTime() {
    return updateTime;
  }
  /** 修改时间的setter方法 */
  public void setUpdateTime(java.util.Date updateTime) {
    this.updateTime = updateTime;
  }
  /** 备用项1的getter方法 */
  public String getByx1() {
    return byx1;
  }
  /** 备用项1的setter方法 */
  public void setByx1(String byx1) {
    this.byx1 = byx1;
  }
  /** 备用项2的getter方法 */
  public String getByx2() {
    return byx2;
  }
  /** 备用项2的setter方法 */
  public void setByx2(String byx2) {
    this.byx2 = byx2;
  }
  /** 备用项3的getter方法 */
  public String getByx3() {
    return byx3;
  }
  /** 备用项3的setter方法 */
  public void setByx3(String byx3) {
    this.byx3 = byx3;
  }

  public Integer getCoordinateX() {
    return coordinateX;
  }

  public void setCoordinateX(Integer coordinateX) {
    this.coordinateX = coordinateX;
  }

  public Integer getCoordinateY() {
    return coordinateY;
  }

  public void setCoordinateY(Integer coordinateY) {
    this.coordinateY = coordinateY;
  }

  public Integer getTextPosition() {
    return textPosition;
  }

  public void setTextPosition(Integer textPosition) {
    this.textPosition = textPosition;
  }

  public String getLineColor() {
    return lineColor;
  }

  public void setLineColor(String lineColor) {
    this.lineColor = lineColor;
  }

  public String getLineCode() {
    return lineCode;
  }

  public void setLineCode(String lineCode) {
    this.lineCode = lineCode;
  }
}
