package com.devplatform.equipment.modules.listation.controller;

import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.model.LiStationModel;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import com.devplatform.equipment.modules.listationmap.service.LiStationMapService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"线路站点管理表接口"})
@RestController
@RequestMapping("/liStation")
public class LiStationController extends AbstractController {

  @Autowired private LiStationService liStationService;
  @Autowired private LiStationMapService liStationMapService;

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取线路站点管理表分页数据列表", notes = "根据条件获取线路站点管理表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestBody LiStationModel model) {
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("order_num");
      model.setOrder("ASC");
    }
    List<LiStation> list = liStationService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * 添加
   *
   * @param bean 线路站点管理表对象
   * @return
   */
  @SysLog("添加线路站点管理表")
  @SysLogMethod(operation = "新增", blockName = "线路站点管理", detail = "新增线路站点数据")
  @ApiOperation(value = "新增线路站点管理表数据", notes = "新增线路站点管理表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "线路站点管理表实体对象", required = true) LiStation bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    liStationService.saveStation(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 线路站点管理表对象
   * @return
   */
  @SysLog("修改线路站点管理表")
  @SysLogMethod(operation = "修改", blockName = "线路站点管理", detail = "修改线路站点数据")
  @ApiOperation(value = "修改线路站点管理表数据", notes = "修改线路站点管理表数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "线路站点管理表实体对象", required = true) LiStation bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    liStationService.updateStation(bean);
    return R.ok();
  }

  /**
   * 根据ID获取线路站点管理表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取线路站点管理表对象", notes = "根据ID获取线路站点管理表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId/{id}")
  public R getId(@PathVariable String id) {
    LiStation bean = liStationService.getById(id);
    List<LiStationMap> mapList = liStationMapService.getListByStationId(id);
    bean.setMapList(mapList);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID获取线路站点管理表对象
   *
   * @param ids 线路站点管理表对象主键数组
   * @return
   */
  @SysLog("删除线路站点管理表")
  @SysLogMethod(operation = "删除", blockName = "线路站点管理", detail = "删除线路站点数据")
  @ApiOperation(value = "根据ID批量删除线路站点管理表数据", notes = "根据ID批量删除线路站点管理表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    liStationService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取站点管理表数据列表", notes = "根据条件获取站点管理表数据列表")
  @ApiImplicitParam(name = "model", value = "参数", required = true, dataType = "LiStationModel")
  @PostMapping("/listAll")
  public R listAll(@RequestBody LiStationModel model) {
    model.setRows(Integer.MAX_VALUE);
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("order_num");
      model.setOrder("ASC");
    }
    List<LiStation> list = liStationService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  @ApiOperation(value = "获取所有站点信息", notes = "获取所有站点信息")
  @GetMapping("/queryAll")
  public R queryAll() {
    return R.ok().put("list", liStationService.list(null));
  }
}
