package com.devplatform.equipment.modules.listation.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.model.LiStationModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * LiStation Mapper 用于线路站点管理表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface LiStationDao extends MyBaseMapper<LiStation> {

  /**
   * 查询分页数量
   *
   * @param model
   * @return
   */
  Integer queryPageByCount(LiStationModel model);

  /**
   * 查询分页数据
   *
   * @param model
   * @return
   */
  List<LiStation> queryPageByList(LiStationModel model);

  /**
   * 查询站点树
   *
   * @param model
   * @return
   */
  List<LiStation> getTreeList(LiStationModel model);
}
