package com.devplatform.equipment.modules.listation.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.model.LiStationModel;
import java.util.List;

/**
 * 线路站点管理表的service接口 <br>
 * <b>功能：</b>LiStationService<br>
 *
 * @author 代码生成器产生
 */
public interface LiStationService extends MyBaseService<LiStation> {
  /**
   * 分页数据查询方法
   *
   * @param model
   * @return
   */
  List<LiStation> queryPageByList(LiStationModel model);

  /**
   * 查询站点树
   *
   * @param model
   * @return
   */
  List<LiStation> getTreeList(LiStationModel model);

  /**
   * 保存站点信息
   *
   * @param bean
   */
  void saveStation(LiStation bean);

  /**
   * 修改站点信息
   *
   * @param bean
   */
  void updateStation(LiStation bean);
}
