package com.devplatform.equipment.modules.listation.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.dao.LiStationDao;
import com.devplatform.equipment.modules.listation.model.LiStationModel;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import com.devplatform.equipment.modules.listationmap.service.LiStationMapService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 线路站点管理表的service接口实现类 <br>
 * <b>功能：</b>LiStationServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("liStationService")
public class LiStationServiceImpl extends MyBaseServiceImpl<LiStationDao, LiStation>
    implements LiStationService {
  @Autowired private LiStationMapService liStationMapService;

  @Override
  public List<LiStation> queryPageByList(LiStationModel model) {
    Integer rowCount = baseMapper.queryPageByCount(model);
    model.getPager().setRowCount(rowCount);
    return baseMapper.queryPageByList(model);
  }

  @Override
  public List<LiStation> getTreeList(LiStationModel model) {
    return baseMapper.getTreeList(model);
  }

  @Override
  public void saveStation(LiStation bean) {
    if (bean.getMapList() != null && bean.getMapList().size() > 0) {
      liStationMapService.saveOrUpdateBatch(bean.getMapList());
    }
    baseMapper.insert(bean);
  }

  @Override
  public void updateStation(LiStation bean) {
    if (bean.getMapList() != null && bean.getMapList().size() > 0) {
      liStationMapService.saveOrUpdateBatch(bean.getMapList());
    }
    baseMapper.update(
        bean,
        new QueryWrapper<LiStation>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId())
            .eq("deleted", 0));
  }
}
