package com.devplatform.equipment.modules.listationmap.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import java.util.List;

/**
 * 线路站点地图附件表的service接口 <br>
 * <b>功能：</b>LiStationMapService<br>
 *
 * @author 代码生成器产生
 */
public interface LiStationMapService extends MyBaseService<LiStationMap> {

  /**
   * 查询站点地图
   *
   * @param model
   * @return
   */
  List<LiStationMap> getTreeList(LiStationMapModel model);

  /**
   * 逻辑删除站点地图
   *
   * @param list
   */
  void deleteByIds(List<String> list);

  /**
   * 查询站点所有地图
   *
   * @param stationId
   * @return
   */
  List<LiStationMap> getListByStationId(String stationId);

  /**
   * 批量更新地图
   *
   * @param list
   */
  void saveOrUpdateBatch(List<LiStationMap> list);
}
