package com.devplatform.equipment.modules.listationmap.service.impl;

import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.modules.listationmap.bean.LiStationMap;
import com.devplatform.equipment.modules.listationmap.dao.LiStationMapDao;
import com.devplatform.equipment.modules.listationmap.model.LiStationMapModel;
import com.devplatform.equipment.modules.listationmap.service.LiStationMapService;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/**
 * 线路站点地图附件表的service接口实现类 <br>
 * <b>功能：</b>LiStationMapServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("liStationMapService")
public class LiStationMapServiceImpl extends MyBaseServiceImpl<LiStationMapDao, LiStationMap>
    implements LiStationMapService {

  @Override
  public List<LiStationMap> getTreeList(LiStationMapModel model) {
    return baseMapper.getTreeList(model);
  }

  @Override
  public void deleteByIds(List<String> list) {
    baseMapper.deleteByIds(list);
  }

  @Override
  public List<LiStationMap> getListByStationId(String stationId) {
    return baseMapper.getListByStationId(stationId);
  }

  @Override
  public void saveOrUpdateBatch(List<LiStationMap> list) {
    if (list != null && list.size() > 0) {
      list.forEach(
          (stationMap) -> {
            if (StringUtil.checkNotNull(stationMap.getId())) {
              baseMapper.updateById(stationMap);
            } else {
              baseMapper.insert(stationMap);
            }
          });
    }
  }
}
