package com.devplatform.equipment.modules.orgate.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.orgate.bean.OrGate;
import com.devplatform.equipment.modules.orgate.model.OrGateModel;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * OrGate Mapper 用于出入口历史指令日志的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface OrGateDao extends MyBaseMapper<OrGate> {

  /**
   * 查询出入口历史指令日志分页数量
   * @param model
   * @return
   */
  Integer queryPageByCount(OrGateModel model);

  /**
   * 出入口历史指令日志分页数据
   * @param model
   * @return
   */
  List<OrGate> queryPageByList(OrGateModel model);

  /**
   * 根据id查询出入口历史指令日志-联动
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById(String id, String stationId);

  /**
   * 根据id查询出入口历史指令日志-报警预案
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById1(String id, String stationId);

  /**
   * 根据id查询出入口历史指令日志-事件决策预案
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById2(String id, String stationId);
}
