package com.devplatform.equipment.modules.orgate.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.orgate.bean.OrGate;
import com.devplatform.equipment.modules.orgate.model.OrGateModel;
import java.util.List;
import java.util.Map;

/**
 * 出入口历史指令日志的service接口 <br>
 * <b>功能：</b>OrGateService<br>
 *
 * @author 代码生成器产生
 */
public interface OrGateService extends MyBaseService<OrGate> {

  /**
   * 根据查询出入口历史指令日志分页数据
   * @param model
   * @return
   */
  List<OrGate> queryPageByList(OrGateModel model);

  /**
   * 根据id查询出入口历史指令日志-联动
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById(String id, String stationId);

  /**
   * 根据id查询出入口历史指令日志-报警预案
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById1(String id, String stationId);

  /**
   * 根据id查询出入口历史指令日志-事件决策预案
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById2(String id, String stationId);
}
