package com.devplatform.equipment.modules.orintrude.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.orintrude.bean.OrIntrude;
import com.devplatform.equipment.modules.orintrude.model.OrIntrudeModel;
import java.util.List;
import java.util.Map;

/**
 * 入侵报警历史指令日志的service接口 <br>
 * <b>功能：</b>OrIntrudeService<br>
 *
 * @author 代码生成器产生
 */
public interface OrIntrudeService extends MyBaseService<OrIntrude> {

  /**
   * 查询入侵报警历史指令日志分页数据
   * @param model
   * @return
   */
  List<OrIntrude> queryPageByList(OrIntrudeModel model);

  /**
   * 根据id查询入侵报警历史指令日志-联动
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById(String id, String stationId);

  /**
   * 根据id查询入侵报警历史指令日志-报警预案
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById1(String id, String stationId);

  /**
   * 根据id查询入侵报警历史指令日志-事件决策预案
   * @param id
   * @param stationId
   * @return
   */
    Map<String, Object> queryById2(String id, String stationId);
}
