package com.devplatform.equipment.modules.orsafetycheck.controller;

import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.common.utils.DateUtil;
import com.devplatform.equipment.modules.liresource.bean.LiResource;
import com.devplatform.equipment.modules.liresource.service.LiResourceService;
import com.devplatform.equipment.modules.orsafetycheck.bean.OrSafetyCheck;
import com.devplatform.equipment.modules.orsafetycheck.model.OrSafetyCheckModel;
import com.devplatform.equipment.modules.orsafetycheck.service.OrSafetyCheckService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"安全检查历史指令日志接口"})
@RestController
@RequestMapping("/orSafetyCheck")
public class OrSafetyCheckController extends AbstractController {

  @Autowired private LiResourceService liResourceService;

  @Autowired private OrSafetyCheckService orSafetyCheckService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象 page 页码 rows 每页条数 stationId 站点id resourceName 资源点名称 startTime 开始时间 endTime
   *     结束时间
   * @return
   */
  @ApiOperation(value = "根据条件获取安全检查历史指令日志分页数据列表", notes = "根据条件获取安全检查历史指令日志分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/list")
  public R list(@RequestBody Map<String, String> params) throws ParseException {
    OrSafetyCheckModel model = new OrSafetyCheckModel();
    // 页码
    String page = params.get("page");
    if (StringUtil.checkNotNull(page)) {
      model.setPage(Integer.parseInt(page));
    }
    // 每页条数
    String rows = params.get("rows");
    if (StringUtil.checkNotNull(rows)) {
      model.setRows(Integer.parseInt(rows));
    }
    // 站点id
    String stationId = params.get("stationId");
    if (StringUtil.checkNotNull(stationId)) {
      model.setStationId(stationId);
    }
    // 操作人
    String createUser = params.get("createName");
    if (StringUtil.checkNotNull(createUser)) {
      model.setCreateUser(createUser);
    }
    // 资源点名称
    String resourceId = params.get("resourceId");
    if (StringUtil.checkNotNull(resourceId)) {
      model.setResourceId(resourceId);
    }

    // 资源点名称
    String resourceName = params.get("resourceName");
    if (StringUtil.checkNotNull(resourceName)) {
      model.setResourceName(resourceName);
    }
    
    // 日期格式化对象
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
    // 开始时间
    String startTime = params.get("startTime");
    if (StringUtil.checkNotNull(startTime)) {
      model.setStartTime(format.parse(startTime));
    }
    // 结束时间
    String endTime = params.get("endTime");
    if (StringUtil.checkNotNull(endTime)) {
      model.setEndTime(format.parse(endTime));
    }
    // 如果开始结束日期都输入，则结束日期必须大于开始日期，
    if (model.getStartTime() != null && model.getEndTime() != null) {
      if (model.getEndTime().getTime() < model.getStartTime().getTime()) {
        return R.error("结束日期必须大于开始日期");
      }
    }
    // 排序条件
    String sort = params.get("sort");
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort(sort);
    }
    String order = params.get("order");
    if (StringUtils.isBlank(model.getOrder())) {
      model.setOrder(order);
    }
    if (StringUtils.isBlank(model.getSort())) {
      model.setSort("create_time");
      model.setOrder("DESC");
    }
    List<OrSafetyCheck> list = orSafetyCheckService.queryPageByList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /**
   * 添加
   *
   * @param bean 安全检查历史指令日志对象 stationId 站点id resourceId 资源点id actionName 动作名称 type 资源点类型
   * @return
   */
  @SysLogMethod(operation = "新增", blockName = "安全检查", detail = "新增历史指令日志数据")
  @ApiOperation(value = "新增安全检查历史指令日志数据", notes = "新增安全检查历史指令日志数据")
  @PostMapping("/save")
  public R save(
      @RequestBody @ApiParam(value = "安全检查历史指令日志实体对象", required = true) OrSafetyCheck bean)
      throws Exception {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    if(Constants.STRING_1.equals(getUser().getSysSystem().getType())){
      bean.setCreateUser(getCurrentUserRealName());
    }else if(Constants.STRING_2.equals(getUser().getSysSystem().getType())){
      bean.setCreateUser("线路管理员");
    }else if(Constants.STRING_3.equals(getUser().getSysSystem().getType())){
      bean.setCreateUser("路网管理员");
    }
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    // 指令id
    String random = Math.random() + "";
    // 指令id，年月日时分秒毫秒+4个随机数
    bean.setInstruction(DateUtil.getNowPlusTimeMill() + random.substring(2, 6));
    // 根据资源id获取资源对象，历史指令日志表资源名格式为：站点名称+层级名称+资源点名称
    LiResource liResource = liResourceService.getBeanById(bean.getResourceId());
    if (liResource != null) {
      bean.setResourceName(liResource.getName());
      bean.setLineStationName(liResource.getLineName() + "-" + liResource.getStationName());
      // 资源点类型名称
      bean.setType(liResource.getTypeName());
    }

    orSafetyCheckService.save(bean);
    return R.ok();
  }

  /**
   * 根据ID获取历史指令
   *
   * @param id 对象主键
   * @return
   */
  @SysLogMethod(operation = "查看", blockName = "安全检查", detail = "查看历史指令详情")
  @ApiOperation(value = "根据ID获取历史指令", notes = "根据ID获取历史指令")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId")
  public R getId(String id, Integer source, String stationId,String byx3) {
    Map<String, Object> map = null;
    if (source == null || source == 1 || source == Constants.INT_2) {
      map = orSafetyCheckService.queryById(id, stationId);
    } else if (source == Constants.INT_3) {
      if(Constants.STRING_1.equals(byx3)){
        map = orSafetyCheckService.queryById1(id, stationId);
      }else if(Constants.STRING_2.equals(byx3)){
        map = orSafetyCheckService.queryById2(id, stationId);
      }
    }
    return R.ok().put("bean", map);
  }
}
