package com.devplatform.equipment.modules.orsafetycheck.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.orsafetycheck.bean.OrSafetyCheck;
import com.devplatform.equipment.modules.orsafetycheck.model.OrSafetyCheckModel;
import java.util.List;
import java.util.Map;

/**
 * 安全检查历史指令日志的service接口 <br>
 * <b>功能：</b>OrSafetyCheckService<br>
 *
 * @author 代码生成器产生
 */
public interface OrSafetyCheckService extends MyBaseService<OrSafetyCheck> {

  /**
   * 查询安全检查历史指令日志分页数据
   * @param model
   * @return
   */
  List<OrSafetyCheck> queryPageByList(OrSafetyCheckModel model);

  /**
   * 根据id查询安全检查历史指令日志-联动
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById(String id, String stationId);

  /**
   * 根据id查询安全检查历史指令日志-报警预案
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById1(String id, String stationId);

  /**
   * 根据id查询安全检查历史指令日志-事件决策预案
   * @param id
   * @param stationId
   * @return
   */
    Map<String, Object> queryById2(String id, String stationId);
}
