package com.devplatform.equipment.modules.orvideomonitor.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

/**
 * @author Administrator
 */
@ApiModel(value = "视频监控历史指令日志对象", description = "视频监控历史指令日志对象")
@TableName("or_video_monitor")
public class OrVideoMonitor implements Serializable {
  /** */
  private static final long serialVersionUID = 1L;

  @ApiModelProperty(value = "主键ID", name = "id")
  @TableId
  private java.lang.String id;

  @ApiModelProperty(value = "资源点id(li_resource表的id)", name = "resourceId")
	/** 资源点id(li_resource表的id)*/
  private java.lang.String resourceId; 

  @ApiModelProperty(value = "资源点名称(站点名称+层级名称+资源点名称)", name = "resourceName")
	/** 资源点名称(站点名称+层级名称+资源点名称)*/
  private java.lang.String resourceName; 

  @ApiModelProperty(value = "指令id", name = "instruction")
	/** 指令id*/
  private java.lang.String instruction; 

  @ApiModelProperty(value = "动作名称", name = "actionName")
	/** 动作名称*/
  private java.lang.String actionName; 

  @ApiModelProperty(value = "执行结果(1=执行成功，2=执行失败)", name = "result")
	/** 执行结果(1=执行成功，2=执行失败)*/
  private Integer result; 

  @ApiModelProperty(value = "创建人id", name = "createUserId")
	/** 创建人*/
  private java.lang.String createUserId; 

  @ApiModelProperty(value = "创建人", name = "createUser")
	/** 创建人*/
  private java.lang.String createUser; 

  @ApiModelProperty(value = "创建时间", name = "createTime")
	/** 创建时间*/
  private java.util.Date createTime; 

  @ApiModelProperty(value = "资源点类型", name = "type")
	/** 资源点类型*/
  private String type; 

  @ApiModelProperty(value = "线路站点名", name = "lineStationName")
	/** 创建时间*/
  private String lineStationName; 

  @ApiModelProperty(value = "站点id", name = "stationId")
	/** 站点id*/
  private String stationId; 

  @ApiModelProperty(value = "数据来源（1：手动执行，2：联动执行，3：预案执行）", name = "source")
	/** 数据来源（1：手动执行，2：联动执行，3：预案执行）*/
  private Integer source; 

  @ApiModelProperty(value = "报警编码", name = "alarmsCode")
	/** 报警编码*/
  private String alarmsCode; 

  @ApiModelProperty(value = "系统标识", name = "sysSign")
	/** 系统标识*/
  private java.lang.String sysSign; 

  @ApiModelProperty(value = "规则与动作关联表id", name = "linkRuleActionId")
  private java.lang.String linkRuleActionId;

  @ApiModelProperty(value = "备用项1", name = "byx1")
	/** 备用项1*/
  private String byx1; 

  @ApiModelProperty(value = "备用项2", name = "byx2")
	/** 备用项2*/
  private String byx2; 

  @ApiModelProperty(value = "备用项3", name = "byx3")
	/** 备用项3*/
  private String byx3; 
  @TableField(exist = false)
	/** 资源点状态*/
  private String status; 

  public OrVideoMonitor() {}

  /**
   * 全参构造
   * @param id
   * @param resourceId
   * @param resourceName
   * @param instruction
   * @param actionName
   * @param result
   * @param createUserId
   * @param createUser
   * @param createTime
   * @param type
   * @param lineStationName
   * @param stationId
   * @param source
   * @param status
   * @param alarmsCode
   * @param linkRuleActionId
   */
  public OrVideoMonitor(
      String id,
      String resourceId,
      String resourceName,
      String instruction,
      String actionName,
      Integer result,
      String createUserId,
      String createUser,
      Date createTime,
      String type,
      String lineStationName,
      String stationId,
      Integer source,
      String status,
      String alarmsCode,
      String linkRuleActionId) {
    this.id = id;
    this.resourceId = resourceId;
    this.resourceName = resourceName;
    this.instruction = instruction;
    this.actionName = actionName;
    this.result = result;
    this.createUserId = createUserId;
    this.createUser = createUser;
    this.createTime = createTime;
    this.type = type;
    this.lineStationName = lineStationName;
    this.stationId = stationId;
    this.source = source;
    this.status = status;
    this.alarmsCode = alarmsCode;
    this.linkRuleActionId = linkRuleActionId;
  }

  public String getLinkRuleActionId() {
    return linkRuleActionId;
  }

  public void setLinkRuleActionId(String linkRuleActionId) {
    this.linkRuleActionId = linkRuleActionId;
  }

  public String getByx1() {
    return byx1;
  }

  public void setByx1(String byx1) {
    this.byx1 = byx1;
  }

  public String getByx2() {
    return byx2;
  }

  public void setByx2(String byx2) {
    this.byx2 = byx2;
  }

  public String getByx3() {
    return byx3;
  }

  public void setByx3(String byx3) {
    this.byx3 = byx3;
  }

  public String getSysSign() {
    return sysSign;
  }

  public void setSysSign(String sysSign) {
    this.sysSign = sysSign;
  }

  public String getAlarmsCode() {
    return alarmsCode;
  }

  public void setAlarmsCode(String alarmsCode) {
    this.alarmsCode = alarmsCode;
  }

  public Integer getSource() {
    return source;
  }

  public void setSource(Integer source) {
    this.source = source;
  }

  public String getStationId() {
    return stationId;
  }

  public void setStationId(String stationId) {
    this.stationId = stationId;
  }

  public String getCreateUser() {
    return createUser;
  }

  public void setCreateUser(String createUser) {
    this.createUser = createUser;
  }

  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public String getLineStationName() {
    return lineStationName;
  }

  public void setLineStationName(String lineStationName) {
    this.lineStationName = lineStationName;
  }

  /** 的getter方法 */
  public java.lang.String getId() {
    return id;
  }
  /** 的setter方法 */
  public void setId(java.lang.String id) {
    this.id = id;
  }
  /** 资源点id(li_resource表的id)的getter方法 */
  public java.lang.String getResourceId() {
    return resourceId;
  }
  /** 资源点id(li_resource表的id)的setter方法 */
  public void setResourceId(java.lang.String resourceId) {
    this.resourceId = resourceId;
  }
  /** 资源点名称(站点名称+层级名称+资源点名称)的getter方法 */
  public java.lang.String getResourceName() {
    return resourceName;
  }
  /** 资源点名称(站点名称+层级名称+资源点名称)的setter方法 */
  public void setResourceName(java.lang.String resourceName) {
    this.resourceName = resourceName;
  }
  /** 指令id的getter方法 */
  public java.lang.String getInstruction() {
    return instruction;
  }
  /** 指令id的setter方法 */
  public void setInstruction(java.lang.String instruction) {
    this.instruction = instruction;
  }
  /** 动作名称的getter方法 */
  public java.lang.String getActionName() {
    return actionName;
  }
  /** 动作名称的setter方法 */
  public void setActionName(java.lang.String actionName) {
    this.actionName = actionName;
  }
  /** 执行结果(1=执行成功，2=执行失败)的getter方法 */
  public Integer getResult() {
    return result;
  }
  /** 执行结果(1=执行成功，2=执行失败)的setter方法 */
  public void setResult(Integer result) {
    this.result = result;
  }
  /** 创建人的getter方法 */
  public java.lang.String getCreateUserId() {
    return createUserId;
  }
  /** 创建人的setter方法 */
  public void setCreateUserId(java.lang.String createUserId) {
    this.createUserId = createUserId;
  }
  /** 创建时间的getter方法 */
  public java.util.Date getCreateTime() {
    return createTime;
  }
  /** 创建时间的setter方法 */
  public void setCreateTime(java.util.Date createTime) {
    this.createTime = createTime;
  }
}
