package com.devplatform.equipment.modules.orvideomonitor.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.orvideomonitor.bean.OrVideoMonitor;
import com.devplatform.equipment.modules.orvideomonitor.model.OrVideoMonitorModel;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * OrVideoMonitor Mapper 用于视频监控历史指令日志的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface OrVideoMonitorDao extends MyBaseMapper<OrVideoMonitor> {

  /**
   * 查询视频监控历史指令日志数量
   * @param model
   * @return
   */
  Integer queryPageByCount(OrVideoMonitorModel model);

  /**
   * 查询视频监控历史指令日志分页数据
   * @param model
   * @return
   */
  List<OrVideoMonitor> queryPageByList(OrVideoMonitorModel model);

  /**
   * 根据id查询视频监控历史指令日志-联动
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById(String id, String stationId);

  /**
   * 根据id查询视频监控历史指令日志-报警预案
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById1(String id, String stationId);

  /**
   * 根据id查询视频监控历史指令日志-事件决策预案
   * @param id
   * @param stationId
   * @return
   */
    Map<String, Object> queryById2(String id, String stationId);
}
