package com.devplatform.equipment.modules.orvideomonitor.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.orvideomonitor.bean.OrVideoMonitor;
import com.devplatform.equipment.modules.orvideomonitor.model.OrVideoMonitorModel;
import java.util.List;
import java.util.Map;

/**
 * 视频监控历史指令日志的service接口 <br>
 * <b>功能：</b>OrVideoMonitorService<br>
 *
 * @author 代码生成器产生
 */
public interface OrVideoMonitorService extends MyBaseService<OrVideoMonitor> {

  /**
   * 查询视频监控历史指令日志分页数据
   * @param model
   * @return
   */
  List<OrVideoMonitor> queryPageByList(OrVideoMonitorModel model);

  /**
   * 根据id查询视频监控历史指令日志-联动
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById(String id, String stationId);

  /**
   * 根据id查询视频监控历史指令日志-报警预案
   * @param id
   * @param stationId
   * @return
   */
  Map<String, Object> queryById1(String id, String stationId);

  /**
   * 根据id查询视频监控历史指令日志-事件决策预案
   * @param id
   * @param stationId
   * @return
   */
    Map<String, Object> queryById2(String id, String stationId);
}
