package com.devplatform.equipment.modules.sys.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.feign.bean.SysLogEntity;
import com.devplatform.equipment.feign.bean.SysUserEntity;

/**
 * 系统日志
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2017-03-08 10:40:56
 */
public interface SysLogService extends MyBaseService<SysLogEntity> {
  /**
   * 保存站点子系统操作日志
   * @param operation 操作类型
   * @param blockName 模块名
   * @param detail 明细
   * @param method 方法
   * @param param 参数
   * @param user 用户信息
   * @param startTime 方法调用开始事件
   * @param sysSign 系统标识
   * @param stationId 站点id
   */
  void saveLogRoutesSub(
      String operation,
      String blockName,
      String detail,
      String method,
      Object param,
      SysUserEntity user,
      Long startTime,
      String sysSign,
      String stationId);
}
