package com.devplatform.equipment.modules.sys.service.impl;

import com.alibaba.fastjson.JSON;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.common.utils.HttpContextUtils;
import com.devplatform.equipment.common.utils.IpUtils;
import com.devplatform.equipment.feign.bean.SysLogEntity;
import com.devplatform.equipment.feign.bean.SysUserEntity;
import com.devplatform.equipment.modules.sys.dao.SysLogDao;
import com.devplatform.equipment.modules.sys.service.SysLogService;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Service;
/**
 * @author Administrator
 */
@Service("sysLogService")
public class SysLogServiceImpl extends MyBaseServiceImpl<SysLogDao, SysLogEntity>
    implements SysLogService {

  @Override
  public void saveLogRoutesSub(
      String operation,
      String blockName,
      String detail,
      String method,
      Object param,
      SysUserEntity user,
      Long startTime,
      String sysSign,
      String stationId) {
    // 记录登录日志
    SysLogEntity sysLog = new SysLogEntity();
    sysLog.setOperation(operation);
    sysLog.setBlockName(blockName);
    sysLog.setDetail(detail);
    sysLog.setMethod(method);
    try {
      String params = JSON.toJSONString(param);
      sysLog.setParams(params);
    } catch (Exception e) {

    }
    // 获取request
    HttpServletRequest request = HttpContextUtils.getHttpServletRequest();
    // 设置IP地址
    sysLog.setIp(IpUtils.getIpAddr(request));
    sysLog.setUserId(user.getUserId());
    sysLog.setOrgId(user.getOrgId());
    Long endTime = System.currentTimeMillis();
    sysLog.setTime(endTime - startTime);
    sysLog.setCreateDate(new Date());
    sysLog.setCreateBy(user.getUserId());
    sysLog.setSysSign(sysSign);
    sysLog.setStationId(stationId);
    if (Constants.STRING_1.equals(user.getSysSystem().getType())) {
      sysLog.setUsername(user.getName());
    } else if (Constants.STRING_2.equals(user.getSysSystem().getType())) {
      sysLog.setUsername("线路管理员");
    } else {
      sysLog.setUsername("路网管理员");
    }
    // 保存系统日志
    save(sysLog);
  }
}
