package com.devplatform.equipment.modules.sysdictionary.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.common.base.annotation.SysLog;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.sysdictionary.bean.SysDictionary;
import com.devplatform.equipment.modules.sysdictionary.model.SysDictionaryModel;
import com.devplatform.equipment.modules.sysdictionary.service.SysDictionaryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
/**
 * @author Administrator
 */
@Api(tags = {"数据字典表接口"})
@RestController
@RequestMapping("/sysDictionary")
public class SysDictionaryController extends AbstractController {
  @Autowired private SysDictionaryService sysDictionaryService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取数据字典表分页数据列表", notes = "根据条件获取数据字典表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = sysDictionaryService.queryPage(params, null);
    return R.ok().put("page", page);
  }

  /**
   * 列表页面列表数据获取
   *
   * @param model 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取数据字典表分页数据列表", notes = "根据条件获取数据字典表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/dictionaryList")
  public R dictionaryList(@RequestBody SysDictionaryModel model) {
    List<SysDictionary> list = sysDictionaryService.queryPageList(model);
    return R.ok().put("page", getMyPage(list, model));
  }

  /** 查询父级下面的子级 */
  @RequestMapping("/getListByParent")
  public R getListByParent(String parentId, String stationId) {
    List<SysDictionary> beans = sysDictionaryService.queryByPid(parentId, stationId);
    return R.ok().put("list", beans);
  }

  /**
   * 添加
   *
   * @param bean 数据字典表对象
   * @return
   */
  @SysLog("添加数据字典表")
  @SysLogMethod(operation = "新增", blockName = "数据字典管理", detail = "新增数据字典数据")
  @ApiOperation(value = "新增数据字典表数据", notes = "新增数据字典表数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "数据字典表实体对象", required = true) SysDictionary bean) {
    ValidatorUtils.validateEntity(bean);
    // 校验参数
    List<SysDictionary> sysDictionaries =
        sysDictionaryService.queryByPid(bean.getParentId(), bean.getStationId());
    for (SysDictionary sysDictionary : sysDictionaries) {
      if (sysDictionary.getName().equals(bean.getName())) {
        return R.error("字典项名称已存在！");
      }
    }
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    sysDictionaryService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 数据字典表对象
   * @return
   */
  @SysLog("修改数据字典表")
  @SysLogMethod(operation = "修改", blockName = "数据字典管理", detail = "修改数据字典数据")
  @ApiOperation(value = "修改数据字典表数据", notes = "修改数据字典表数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "数据字典表实体对象", required = true) SysDictionary bean) {
    ValidatorUtils.validateEntity(bean);
    // 校验参数
    List<SysDictionary> sysDictionaries =
        sysDictionaryService.queryByPid(bean.getParentId(), bean.getStationId());
    for (SysDictionary sysDictionary : sysDictionaries) {
      if (!sysDictionary.getId().equals(bean.getId())
          && bean.getName().equals(sysDictionary.getName())) {
        return R.error("字典项名称已存在！");
      }
    }
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    sysDictionaryService.update(
        bean,
        new QueryWrapper<SysDictionary>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId())
            .eq(StringUtil.checkNotNull(bean.getStationId()), "station_id", bean.getStationId()));
    return R.ok();
  }

  /**
   * 根据ID获取数据字典表对象
   *
   * @param id 对象主键
   * @return
   */
  @ApiOperation(value = "根据ID获取数据字典表对象", notes = "根据ID获取数据字典表对象")
  @ApiImplicitParam(name = "id", value = "主键", required = true, dataType = "String")
  @GetMapping("/getId")
  public R getId(String id, String stationId) {
    SysDictionary bean = sysDictionaryService.queryById(id, stationId);
    return R.ok().put("bean", bean);
  }

  /**
   * 根据ID删除数据字典表对象
   *
   * @param
   * @return
   */
  @SysLog("删除数据字典表")
  @SysLogMethod(operation = "删除", blockName = "数据字典管理", detail = "删除数据字典数据")
  @ApiOperation(value = "根据ID批量删除数据字典表数据", notes = "根据ID批量删除数据字典表数据")
  @PostMapping("/deleteById")
  public R deleteById(
      @RequestBody @ApiParam(value = "数据字典表实体对象", required = true) SysDictionary bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setDeleted(1);
	// 如果是二级，不可以删除，只能修改
    if (Constants.DIC_ROOT_ID.equals(bean.getParentId())) { 
      return R.error(111, "该字典项不可以删除，只能修改!");
    }
    bean.setSysSign(getUser().getSysSystem().getCode());
    sysDictionaryService.update(
        bean,
        new QueryWrapper<SysDictionary>()
            .eq(StringUtil.checkNotNull(bean.getId()), "id", bean.getId())
            .eq(StringUtil.checkNotNull(bean.getStationId()), "station_id", bean.getStationId()));
    return R.ok();
  }

  /**
   * @param ids 数据字典表对象主键数组
   * @return 根据ID获取数据字典表对象
   */
  @SysLog("删除数据字典表")
  @ApiOperation(value = "根据ID批量删除数据字典表数据", notes = "根据ID批量删除数据字典表数据")
  @ApiImplicitParam(name = "ids", value = "主键数组", required = true, dataType = "String")
  @PostMapping("/delete")
  public R delete(@RequestBody String[] ids) {
    sysDictionaryService.removeByIds(Arrays.asList(ids));
    return R.ok();
  }

  /**
   * 获取数据字典
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "获取所有数据字典", notes = "获取所有数据字典")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @GetMapping("/dictionaryAllList")
  public R dictionaryAllList(@RequestParam Map<String, Object> params) {
    List<SysDictionary> lists = sysDictionaryService.getAllDictionary(params);
    return R.ok().put("list", lists);
  }

  /**
   * 获取子系统字典项
   *
   * @return
   */
  @ApiOperation(value = "获取子系统字典项", notes = "获取子系统字典项")
  @GetMapping("/getSubSystemDicList")
  public R getSubSystemDicList(String stationId) {
    List<SysDictionary> list = sysDictionaryService.queryByPid(Constants.SUB_SYSTEM_ID, stationId);
    return R.ok().put("list", list);
  }

  /**
   * 获取资源点类型字典项
   *
   * @return
   */
  @ApiOperation(value = "获取资源点类型字典项", notes = "获取资源点类型字典项")
  @GetMapping("/getResourceTypeDicList")
  public R getResourceTypeDicList(String stationId) {
    List<SysDictionary> list = sysDictionaryService.queryByPid(Constants.RESOURCE_TYPE, stationId);
    return R.ok().put("list", list);
  }

  /**
   * 获取设备告警类型字典项
   *
   * @return
   */
  @ApiOperation(value = "获取设备告警类型字典项", notes = "获取设备告警类型字典项")
  @GetMapping("/getAlarmTypeDicList")
  public R getAlarmTypeDicList(String stationId) {
    List<SysDictionary> list = sysDictionaryService.queryByPid(Constants.EQ_ALARM_TYPE, stationId);
    return R.ok().put("list", list);
  }
}
