package com.devplatform.equipment.modules.sysdictionary.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.sysdictionary.bean.SysDictionary;
import com.devplatform.equipment.modules.sysdictionary.model.SysDictionaryModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * SysDictionary Mapper 用于数据字典表的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface SysDictionaryDao extends MyBaseMapper<SysDictionary> {
  /**
   * 根据id查询字典
   * @param id
   * @param stationId
   * @return
   */
  SysDictionary queryById(@Param("id") String id, @Param("stationId") String stationId);

  /**
   * 查询分页数量
   *
   * @param model
   * @return
   */
  Integer queryPageByCount(@Param("model") SysDictionaryModel model);

  /**
   * 根据父节点id查询字典
   * @param parentId
   * @param stationId
   * @return
   */
  List<SysDictionary> queryByPid(
      @Param("parentId") String parentId, @Param("stationId") String stationId);

  /**
   * 查询字典分页数据
   * @param model
   * @return
   */
  List<SysDictionary> queryPageList(@Param("model") SysDictionaryModel model);

  /**
   * 根据父节点查询数量
   * @param parentId
   * @param stationId
   * @return
   */
  Integer queryCountByParentId(
      @Param("parentId") String parentId, @Param("stationId") String stationId);

  /**
   * 查询子系统字典
   * @param subParentId
   * @param subCode
   * @param stationId
   * @return
   */
  String querySubId(
      @Param("subParentId") String subParentId,
      @Param("subCode") String subCode,
      @Param("stationId") String stationId);
}
