package com.devplatform.equipment.modules.sysdictionary.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.sysdictionary.bean.SysDictionary;
import com.devplatform.equipment.modules.sysdictionary.model.SysDictionaryModel;
import java.util.List;
import java.util.Map;

/**
 * 数据字典表的service接口 <br>
 * <b>功能：</b>SysDictionaryService<br>
 *
 * @author 代码生成器产生
 */
public interface SysDictionaryService extends MyBaseService<SysDictionary> {
  /**
   * 根据id查询字典
   * @param id
   * @param stationId
   * @return
   */
  public SysDictionary queryById(String id, String stationId);

  /**
   * 根据父节点查询字典
   * @param parentId
   * @param stationId
   * @return
   */
  public List<SysDictionary> queryByPid(String parentId, String stationId);

  /**
   * 查询字典分页数据
   * @param model
   * @return
   */
  public List<SysDictionary> queryPageList(SysDictionaryModel model);

  /**
   * 查询所有字典
   * @param params
   * @return
   */
  public List<SysDictionary> getAllDictionary(Map<String, Object> params);

  /**
   * 根据父节点id查询数量
   * @param parentId
   * @param stationId
   * @return
   */
  public Integer queryCountByParentId(String parentId, String stationId);

  /**
   * 查询子系统字典
   * @param subCode
   * @param stationId
   * @return
   */
  String querySubId(String subCode, String stationId);
}
