package com.devplatform.equipment.modules.sysdictionary.service.impl;

import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.sysdictionary.bean.SysDictionary;
import com.devplatform.equipment.modules.sysdictionary.dao.SysDictionaryDao;
import com.devplatform.equipment.modules.sysdictionary.model.SysDictionaryModel;
import com.devplatform.equipment.modules.sysdictionary.service.SysDictionaryService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 数据字典表的service接口实现类 <br>
 * <b>功能：</b>SysDictionaryServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("sysDictionaryService")
public class SysDictionaryServiceImpl extends MyBaseServiceImpl<SysDictionaryDao, SysDictionary>
    implements SysDictionaryService {
  @Autowired private SysDictionaryDao mapper;

  @Override
  public SysDictionary queryById(String id, String stationId) {
    return mapper.queryById(id, stationId);
  }

  @Override
  public List<SysDictionary> queryByPid(String parentId, String stationId) {
    return mapper.queryByPid(parentId, stationId);
  }

  @Override
  public List<SysDictionary> queryPageList(SysDictionaryModel model) {
    Integer rowCount = baseMapper.queryPageByCount(model);
    model.getPager().setRowCount(rowCount);
    return mapper.queryPageList(model);
  }

  @Override
  public List<SysDictionary> getAllDictionary(Map<String, Object> params) { // 只查二级
    String stationId = "";
    if (params.containsKey(Constants.STATION_ID)) {
      stationId = (String) params.get("stationId");
    }
    List<SysDictionary> lists = mapper.queryByPid(null, stationId);
    if (lists != null && lists.size() > 0) {
      for (int i = 0; i < lists.size(); i++) {
        List<SysDictionary> list = mapper.queryByPid(lists.get(i).getId(), stationId);
        if (list != null && list.size() > 0) {
          lists.get(i).setChildren(list);
        }
      }
    }
    return lists;
  }

  @Override
  public Integer queryCountByParentId(String parentId, String stationId) {
    return mapper.queryCountByParentId(parentId, stationId);
  }

  @Override
  public String querySubId(String subCode, String stationId) {
    return mapper.querySubId(Constants.SUB_PARENT_ID, subCode, stationId);
  }
}
