package com.devplatform.equipment.modules.sysparams.dao;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.sysparams.bean.SysParams;
import com.devplatform.equipment.modules.sysparams.model.SysParamsModel;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

/**
 * SysParams Mapper 用于系统参数配置的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface SysParamsDao extends MyBaseMapper<SysParams> {

  /**
   * 查询系统参数配置分页数据
   * @param pageTask
   * @param model
   * @return
   */
  public Page<SysParams> queryPageList(
      @Param("pageTask") Page<SysParams> pageTask, @Param("model") SysParamsModel model);

  /**
   * 根据id查询系统配置
   * @param id
   * @param stationId
   * @return
   */
  SysParams queryById(@Param("id") String id, @Param("stationId") String stationId);
}
