package com.devplatform.equipment.modules.syspreset.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.syspreset.bean.SysPreset;
import com.devplatform.equipment.modules.syspreset.model.SysPresetModel;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * SysPreset Mapper 用于预置点管理的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface SysPresetDao extends MyBaseMapper<SysPreset> {

  /**
   * 查询预置点分页数量
   * @param model
   * @return
   */
  Integer queryPageByCount(SysPresetModel model);

  /**
   * 查询预置点分页数据
   * @param model
   * @return
   */
  List<SysPreset> queryPageByList(SysPresetModel model);

  /**
   * 根据资源点id计算编号被使用次数
   * @param id
   * @param resourceId
   * @param orderNum
   * @param stationId
   * @return
   */
  Integer countByResourceId(String id, String resourceId, Integer orderNum, String stationId);
}
