package com.devplatform.equipment.modules.sysuser.controller;

import com.devplatform.common.util.R;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.modules.sysuser.bean.SysUser;
import com.devplatform.equipment.modules.sysuser.service.SysUserService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
/**
 * @author Administrator
 */
@Api(tags = {"系统用户表接口"})
@RestController
@RequestMapping("/sysUser")
public class SysUserController extends AbstractController {

  @Autowired private SysUserService sysUserService;

  /**
   * 列表页面列表数据获取
   *
   * @return
   */
  @ApiOperation(value = "获取所有系统用户", notes = "获取所有系统用户")
  @GetMapping("/getAllSysUser")
  public R getAllSysUserNameAndId(String stationId) {
    List<SysUser> users = sysUserService.getAllSysUser(stationId);
    ArrayList<Map<String, String>> list = new ArrayList<>();
    for (SysUser user : users) {
      HashMap<String, String> map = new HashMap<>(5);
      map.put("patrollerId", user.getUserId());
      map.put("patrollerName", user.getName());
      map.put("nameMobile", user.getName() + "-" + user.getMobile());
      list.add(map);
    }
    return R.ok().put("users", list);
  }
}
