package com.devplatform.equipment.modules.videotask.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.devplatform.common.base.validator.ValidatorUtils;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.listation.bean.LiStation;
import com.devplatform.equipment.modules.listation.service.LiStationService;
import com.devplatform.equipment.modules.videotask.bean.VideoTask;
import com.devplatform.equipment.modules.videotask.service.VideoTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
/**
 * @author Administrator
 */
@Api(tags = {"视频轮播任务管理接口"})
@RestController
@RequestMapping("/videoTask")
public class VideoTaskController extends AbstractController {
  @Autowired private VideoTaskService videoTaskService;

  @Autowired private LiStationService liStationService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象 stationId 站点Id
   * @return
   */
  @ApiOperation(value = "根据条件获取视频轮播任务管理数据列表", notes = "根据条件获取视频轮播任务管理数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/list")
  public R list(@RequestBody Map<String, String> params) {
    List<VideoTask> list = null;
    String stationId = params.get("stationId");
    if (StringUtil.checkNotNull(Constants.STATION_ID)) {
      list = videoTaskService.queryByStationId(stationId);
    }
    LiStation liStation = liStationService.getById(stationId);
    // 返回一个线路站点名
    return R.ok()
        .put("list", list)
        .put("lineStation", liStation.getLineName() + "-" + liStation.getStationName());
  }
  /**
   * 添加
   *
   * @param bean 视频轮播任务管理对象 stationId 站点id name 任务名称 type 轮训宫格数量(1=1X,2=4X,3=9X,4=16X) pollInterval
   *     轮训间隔(单位秒) remark 备注
   * @return
   */
  @SysLogMethod(operation = "新增", blockName = "视频监控", detail = "新增视频轮播任务数据")
  @ApiOperation(value = "新增视频轮播任务管理数据", notes = "新增视频轮播任务管理数据")
  @PostMapping("/save")
  public R save(@RequestBody @ApiParam(value = "视频轮播任务管理实体对象", required = true) VideoTask bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setCreateUserId(getUserId());
    bean.setCreateTime(new Date());
    bean.setDeleted(0);
    bean.setSysSign(getUser().getSysSystem().getCode());
    videoTaskService.save(bean);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param bean 视频轮播任务管理对象
   * @return
   */
  @SysLogMethod(operation = "修改", blockName = "视频监控", detail = "修改视频轮播任务数据")
  @ApiOperation(value = "修改视频轮播任务管理数据", notes = "修改视频轮播任务管理数据")
  @PostMapping("/update")
  public R update(@RequestBody @ApiParam(value = "视频轮播任务管理实体对象", required = true) VideoTask bean) {
    ValidatorUtils.validateEntity(bean);
    bean.setUpdateUserId(getUserId());
    bean.setUpdateTime(new Date());
    bean.setSysSign(getUser().getSysSystem().getCode());
    videoTaskService.update(
        bean,
        new LambdaQueryWrapper<VideoTask>()
            .eq(VideoTask::getId, bean.getId())
            .eq(
                StringUtil.checkNotNull(bean.getStationId()),
                VideoTask::getStationId,
                bean.getStationId()));
    return R.ok();
  }

  /**
   * 根据ID删除视频轮播任务管理对象
   *
   * @param params 视频轮播任务管理对象主键数组
   * @return
   */
  @SysLogMethod(operation = "删除", blockName = "视频监控", detail = "删除视频轮播任务数据")
  @ApiOperation(value = "根据ID删除视频轮播任务管理数据", notes = "根据ID删除视频轮播任务管理数据")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/delete")
  public R delete(@RequestBody Map<String, String> params) {
    String id = params.get("id");
    String stationId = params.get("stationId");
    if (StringUtil.checkNotNull(id)) {
      // 逻辑删除
      videoTaskService.delete(id, stationId);
    }
    return R.ok();
  }
}
