package com.devplatform.equipment.modules.videotask.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.videotask.bean.VideoTask;
import java.util.List;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * VideoTask Mapper 用于视频轮播任务管理的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface VideoTaskDao extends MyBaseMapper<VideoTask> {

  /**
   * 根据id删除
   * @param id
   * @param stationId
   */
  void delete(String id, String stationId);

  /**
   * 查询视频轮播任务
   * @param stationId
   * @return
   */
  List<VideoTask> queryByStationId(String stationId);
}
