package com.devplatform.equipment.modules.videotaskresource.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.devplatform.common.util.R;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.common.annotation.SysLogMethod;
import com.devplatform.equipment.common.utils.AbstractController;
import com.devplatform.equipment.common.utils.Constants;
import com.devplatform.equipment.modules.videotaskresource.bean.VideoTaskResource;
import com.devplatform.equipment.modules.videotaskresource.service.VideoTaskResourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
/**
 * @author Administrator
 */
@Api(tags = {"视频轮播任务资源点管理接口"})
@RestController
@RequestMapping("/videoTaskResource")
public class VideoTaskResourceController extends AbstractController {
  @Autowired private VideoTaskResourceService videoTaskResourceService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象 taskId 任务id
   * @return
   */
  @ApiOperation(value = "根据条件获取视频轮播任务资源点管理数据列表", notes = "根据条件获取视频轮播任务资源点管理数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/list")
  public R list(@RequestBody Map<String, String> params) {
    List<Map<String, Object>> list = null;
    String taskId = params.get("taskId");
    String stationId = params.get("stationId");
    if (StringUtil.checkNotNull(Constants.TASK_ID)) {
      // 根据任务id获取到所有任务资源点
      list = videoTaskResourceService.queryByTaskId(taskId, stationId);
    }
    return R.ok().put("list", list);
  }

  /**
   * 添加
   *
   * @param params 视频轮播任务资源点管理对象 taskId 任务id resourceIds 资源点id集合
   * @return
   */
  @SysLogMethod(operation = "新增", blockName = "视频监控", detail = "新增视频轮播任务资源点数据")
  @ApiOperation(value = "新增视频轮播任务资源点管理数据", notes = "新增视频轮播任务资源点管理数据")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/save")
  public R save(@RequestBody Map<String, Object> params) {
    params.put("sysSign", getUser().getSysSystem().getCode());
    videoTaskResourceService.saveList(params);
    return R.ok();
  }

  /**
   * 修改
   *
   * @param params 承接对象 id1 视频轮播任务资源点id1 id2 视频轮播任务资源点id2
   * @return
   */
  @SysLogMethod(operation = "修改", blockName = "视频监控", detail = "修改视频轮播任务资源点数据")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/update")
  public R update(@RequestBody Map<String, String> params) {
    String id1 = params.get("id1");
    String id2 = params.get("id2");
    String stationId = params.get("stationId");
    if (StringUtil.checkNotNull(id1) && StringUtil.checkNotNull(id2)) {
      videoTaskResourceService.changeSortByIds(id1, id2, stationId);
    }
    return R.ok();
  }

  /**
   * 根据ID删除视频轮播任务资源点管理对象
   *
   * @param params 视频轮播任务管理对象主键
   * @return
   */
  @SysLogMethod(operation = "删除", blockName = "视频监控", detail = "删除视频轮播任务资源点数据")
  @ApiOperation(value = "根据ID删除视频轮播任务资源点管理数据", notes = "根据ID删除视频轮播任务资源点管理数据")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, String>")
  @PostMapping("/delete")
  public R delete(@RequestBody Map<String, String> params) {
    String id = params.get("id");
    String stationId = params.get("stationId");
    if (StringUtil.checkNotNull(id)) {
      videoTaskResourceService.remove(
          new LambdaQueryWrapper<VideoTaskResource>()
              .eq(VideoTaskResource::getId, id)
              .eq(StringUtil.checkNotNull(stationId), VideoTaskResource::getStationId, stationId));
    }
    return R.ok();
  }
}
