package com.devplatform.equipment.modules.videotaskresource.dao;

import com.devplatform.common.dao.MyBaseMapper;
import com.devplatform.equipment.modules.videotaskresource.bean.VideoTaskResource;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

/**
 * VideoTaskResource Mapper 用于视频轮播任务资源点管理的数据库操作
 *
 * @author Administrator
 */
@Mapper
@Repository
public interface VideoTaskResourceDao extends MyBaseMapper<VideoTaskResource> {

  /**
   * 根据任务id查询数据
   * @param taskId
   * @param stationId
   * @return
   */
  List<Map<String, Object>> queryByTaskId(String taskId, String stationId);

  /**
   * 查询最大排序值
   * @param taskId
   * @param stationId
   * @return
   */
  Integer getMaxSort(String taskId, String stationId);
}
