package com.devplatform.equipment.modules.videotaskresource.service;

import com.devplatform.common.service.MyBaseService;
import com.devplatform.equipment.modules.videotaskresource.bean.VideoTaskResource;
import java.util.List;
import java.util.Map;

/**
 * 视频轮播任务资源点管理的service接口 <br>
 * <b>功能：</b>VideoTaskResourceService<br>
 *
 * @author 代码生成器产生
 */
public interface VideoTaskResourceService extends MyBaseService<VideoTaskResource> {
  /**
   * 根据任务id获取任务资源点列表
   * @param taskId
   * @param stationId
   * @return
   */
  List<Map<String, Object>> queryByTaskId(String taskId, String stationId);

  /**
   * 根据轮播任务资源点互换排序值
   * @param id1
   * @param id2
   * @param stationId
   */
  void changeSortByIds(String id1, String id2, String stationId);

  /**
   * 批量保存
   *
   * @param params
   */
  void saveList(Map<String, Object> params);
}
