package com.devplatform.equipment.modules.videotaskresource.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.devplatform.common.service.impl.MyBaseServiceImpl;
import com.devplatform.common.util.StringUtil;
import com.devplatform.equipment.modules.videotaskresource.bean.VideoTaskResource;
import com.devplatform.equipment.modules.videotaskresource.dao.VideoTaskResourceDao;
import com.devplatform.equipment.modules.videotaskresource.service.VideoTaskResourceService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 视频轮播任务资源点管理的service接口实现类 <br>
 * <b>功能：</b>VideoTaskResourceServiceImpl<br>
 *
 * @author 代码生成器产生
 */
@Service("videoTaskResourceService")
public class VideoTaskResourceServiceImpl
    extends MyBaseServiceImpl<VideoTaskResourceDao, VideoTaskResource>
    implements VideoTaskResourceService {

  @Override
  public List<Map<String, Object>> queryByTaskId(String taskId, String stationId) {
    return baseMapper.queryByTaskId(taskId, stationId);
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void changeSortByIds(String id1, String id2, String stationId) {
    VideoTaskResource videoTaskResource1 =
        baseMapper.selectOne(
            new LambdaQueryWrapper<VideoTaskResource>()
                .eq(VideoTaskResource::getId, id1)
                .eq(
                    StringUtil.checkNotNull(stationId),
                    VideoTaskResource::getStationId,
                    stationId));
    VideoTaskResource videoTaskResource2 =
        baseMapper.selectOne(
            new LambdaQueryWrapper<VideoTaskResource>()
                .eq(VideoTaskResource::getId, id2)
                .eq(
                    StringUtil.checkNotNull(stationId),
                    VideoTaskResource::getStationId,
                    stationId));
    Integer sort1 = videoTaskResource1.getSort();
    videoTaskResource1.setSort(videoTaskResource2.getSort());
    videoTaskResource2.setSort(sort1);
    baseMapper.update(
        videoTaskResource1,
        new LambdaQueryWrapper<VideoTaskResource>()
            .eq(VideoTaskResource::getId, id1)
            .eq(StringUtil.checkNotNull(stationId), VideoTaskResource::getStationId, stationId));
    baseMapper.update(
        videoTaskResource2,
        new LambdaQueryWrapper<VideoTaskResource>()
            .eq(VideoTaskResource::getId, id2)
            .eq(StringUtil.checkNotNull(stationId), VideoTaskResource::getStationId, stationId));
  }

  @Override
  @Transactional(rollbackFor = Exception.class)
  public void saveList(Map<String, Object> params) {
    String taskId = (String) params.get("taskId");
    String sysSign = (String) params.get("sysSign");
    String stationId = (String) params.get("stationId");
    List<String> resourceIds = (List<String>) params.get("resourceIds");
    // 根据任务获取该任务最后一个资源点的排序值，没有则从1开始
    Integer sort = baseMapper.getMaxSort(taskId, stationId);

    if (sort == null) {
      sort = 0;
    }
    ArrayList<VideoTaskResource> videoTaskResources = new ArrayList<>();
    for (String resourceId : resourceIds) {
      sort++;
      VideoTaskResource videoTaskResource = new VideoTaskResource();
      videoTaskResource.setSort(sort);
      videoTaskResource.setResourceId(resourceId);
      videoTaskResource.setTaskId(taskId);
      videoTaskResource.setSysSign(sysSign);
      videoTaskResource.setStationId(stationId);
      videoTaskResources.add(videoTaskResource);
    }
    saveBatch(videoTaskResources);
  }
}
