package com.devplatform.transfer;

import lombok.extern.slf4j.Slf4j;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
/**
 * @author Administrator
 */
@SpringBootApplication
@EnableSwagger2
@Slf4j
@MapperScan(basePackages = "com.devplatform.**.dao")
@EnableEurekaClient
@EnableFeignClients
@EnableScheduling
@EnableTransactionManagement
public class TransferApplication {

  public static void main(String[] args) {
    SpringApplication.run(TransferApplication.class, args);
  }
}
