package com.devplatform.transfer.canal;

import com.alibaba.otter.canal.client.CanalConnector;
import com.alibaba.otter.canal.client.CanalConnectors;
import com.alibaba.otter.canal.protocol.CanalEntry.*;
import com.alibaba.otter.canal.protocol.Message;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.devplatform.transfer.common.util.Constants;
import com.devplatform.transfer.common.util.DruidUtils;
import com.devplatform.transfer.common.util.ThreadPool;
import com.devplatform.transfer.modules.sys.bean.SysSynchDatalog;
import com.devplatform.transfer.modules.sys.service.SysSynchDatalogService;
import com.devplatform.transfer.modules.syssystem.bean.SysSystem;
import com.google.protobuf.InvalidProtocolBufferException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import sun.net.util.IPAddressUtil;

import javax.annotation.Resource;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 站点数据同步
 *
 * @author Muceball
 * @date 2020/10/26
 */
@Component
public class ExecuteSql {
    @Autowired
    @Resource(name = "sysSynchDatalogService")
    private SysSynchDatalogService sysSynchDatalogService;

    private String serverAddress;
    public final String filter = "crsf\\..*";
    private final static Integer PORT = 11111;
    private final static String DESTINATION = "example";
    private final static String USERNAME = "admin";
    private final static String PASSWORD = "6C2B8E71667AD05C848544A8EDEDD834CANAL";
    private ConcurrentHashMap<String, ConcurrentLinkedQueue<String>> druidPool = new ConcurrentHashMap<>();
    private List<DruidUtils> druidUtilsList;
    private CopyOnWriteArrayList<String> errorLink = new CopyOnWriteArrayList<>();
    private CopyOnWriteArrayList<String> recoverLink = new CopyOnWriteArrayList<>();
    private String code;
    private String type;

    /**
     * canal入库方法
     */
    public void run(List<DruidUtils> druidUtilsList, SysSystem one) {
        this.type = one.getType();
        this.code = one.getCode();
        this.druidUtilsList = druidUtilsList;
        String byx3 = one.getByx3();

        if (StringUtils.isNotBlank(byx3) && IPAddressUtil.isIPv4LiteralAddress(byx3)) {
            serverAddress = byx3;
        } else {
            try {
                serverAddress = InetAddress.getLocalHost().getHostAddress();
            } catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        System.out.println("=====================================\n当前连接的canal服务器IP为：" + serverAddress + "\n=====================================");
        druidPool.clear();
        this.druidUtilsList.forEach(key -> druidPool.put(key.getStationId(), new ConcurrentLinkedQueue<>()));
        CanalConnector canalConnector = CanalConnectors.newSingleConnector(new InetSocketAddress(serverAddress, PORT), DESTINATION, USERNAME, PASSWORD);
        //查询出又异常数据的链接，加入到错误列表
        QueryWrapper<SysSynchDatalog> queryList = new QueryWrapper<SysSynchDatalog>().select("station_id AS stationId, COUNT(1) AS total").eq("`status`", 0).having("total > 0");
        List<Map<String, Object>> list = sysSynchDatalogService.listMaps(queryList);
        list.forEach(item ->{
            this.checkLink(item.get("stationId").toString());
        });
        int batchSize = 1000;
        try {
            canalConnector.connect();
            System.out.println("==========已连接==========");
            canalConnector.subscribe(filter);
            canalConnector.rollback();
            while (true) {
                // 尝试从master那边拉去数据batchSize条记录，有多少取多少
                Message message = canalConnector.getWithoutAck(batchSize);
                long batchId = message.getId();
                int size = message.getEntries().size();
                if (batchId == -1 || size == 0) {
                    Thread.sleep(100);
                } else {
                    dataHandle(message.getEntries());
                }
                executeSql(druidUtilsList);
                canalConnector.ack(batchId);
            }
        } catch (Exception e) {
            System.out.println("重启...");
            try {
                Thread.sleep(3000);
            } catch (InterruptedException e2) {
                e2.printStackTrace();
            }
            // 直接重启-----直接递归。可能出现oom，有待确认
            run(druidUtilsList, one);
        } finally {
            canalConnector.disconnect();
        }
    }

    /**
     * 执行SQL
     *
     * @param druidUtilsList 连接池集合
     * @throws InterruptedException
     */
    private void executeSql(List<DruidUtils> druidUtilsList) throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(druidPool.size());
        for (Map.Entry<String, ConcurrentLinkedQueue<String>> entry : druidPool.entrySet()) {
            ThreadPool.threadPoolExecutor.execute(
                    () -> {
                        // 执行逻辑
                        if (!entry.getValue().isEmpty()) {
                            for (DruidUtils druidUtils : druidUtilsList) {
                                String stationId = druidUtils.getStationId();
                                if (stationId.equals(entry.getKey())) {
                                    if (recoverLink.contains(stationId)) {
                                        //先执行数据库中的SQL
                                        boolean b = runErrorSql(stationId);
                                        if (b) {
                                            //执行过程中无报错
                                            errorLink.remove(stationId);
                                            recoverLink.remove(stationId);
                                        }
                                    }
                                    ConcurrentLinkedQueue<String> value = entry.getValue();
                                    int sqlSize = value.size();
                                    for (int i = 0; i < sqlSize; i++) {
                                        String sql = value.poll();
                                        Connection connection = null;
                                        PreparedStatement preparedStatement = null;
                                        boolean execute = true;
                                        if (!errorLink.isEmpty() && errorLink.contains(stationId)) {
                                            saveErrorSql(stationId, sql, sysSynchDatalogService, Constants.INT_0, "创建链接失败，自动持久化");
                                        } else {
                                            try {
                                                connection = druidUtils.getConnection();
                                                preparedStatement = connection.prepareStatement(sql);
                                                try {
                                                    execute = preparedStatement.execute();
                                                } catch (SQLException throwable) {
                                                    saveErrorSql(stationId, sql, sysSynchDatalogService, Constants.INT_2, throwable.toString());
                                                }
                                            } catch (SQLException exception) {
                                                //添加异常库
                                                //启动异常服务监控
                                                checkLink(stationId);
                                                saveErrorSql(stationId, sql, sysSynchDatalogService, Constants.INT_0, "创建链接失败");
                                            } finally {
                                                if (!execute) {
                                                    System.out.println("SQL执行成功！");
                                                } else {
                                                    System.out.println("SQL执行失败！");
                                                }
                                                System.out.println("\t" + sql);
                                                druidUtils.close(preparedStatement, connection);
                                            }
                                        }

                                    }
                                }
                            }
                        }
                        latch.countDown();
                    });
        }
        latch.await();
    }

    private void saveErrorSql(String stationId, String sql, SysSynchDatalogService sysSynchDatalogService, int status, String byx1) {
        SysSynchDatalog syncLog = new SysSynchDatalog();
        syncLog.setStationId(stationId);
        syncLog.setSqlStr(sql);
        syncLog.setStatus(status);
        syncLog.setCreateTime(new Date());
        syncLog.setByx1(byx1);
        sysSynchDatalogService.save(syncLog);
    }

    /**
     * 数据处理
     *
     * @param entrys
     */
    private void dataHandle(List<Entry> entrys) throws InvalidProtocolBufferException {
        for (Entry entry : entrys) {
            if (EntryType.ROWDATA == entry.getEntryType()) {
                RowChange rowChange = RowChange.parseFrom(entry.getStoreValue());
                EventType eventType = rowChange.getEventType();
                if (eventType == EventType.DELETE) {
                    saveDeleteSql(entry);
                } else if (eventType == EventType.UPDATE) {
                    saveUpdateSql(entry);
                } else if (eventType == EventType.INSERT) {
                    saveInsertSql(entry);
                }
            }
        }
    }

    /**
     * 保存更新语句
     *
     * @param entry
     */
    private void saveUpdateSql(Entry entry) {
        try {
            RowChange rowChange = RowChange.parseFrom(entry.getStoreValue());
            List<RowData> rowDatasList = rowChange.getRowDatasList();
            for (RowData rowData : rowDatasList) {
                List<Column> newColumnList = rowData.getAfterColumnsList();
                StringBuilder sql = new StringBuilder();
                sql.append("update `").append(entry.getHeader().getTableName()).append("` set ");

                String key = null;
                String sysSign = null;
                for (int i = 0; i < newColumnList.size(); i++) {
                    String name = newColumnList.get(i).getName();
                    sql.append("`").append(name).append("` = ");
                    String value = newColumnList.get(i).getValue();
                    if ("station_id".equals(name)) {
                        key = value;
                    }
                    if ("sys_sign".equals(name)) {
                        sysSign = value;
                    }
                    if ("".equals(value)) {
                        sql.append("null");
                    } else {
                        sql.append("'").append(value).append("'");
                    }
                    if (i != newColumnList.size() - 1) {
                        sql.append(" , ");
                    }
                }
                sql.append(" where ");
                List<Column> oldColumnList = rowData.getBeforeColumnsList();
                for (Column column : oldColumnList) {
                    if (column.getIsKey()) {
                        // 暂时只支持单一主键
                        sql.append(column.getName()).append(" = '").append(column.getValue()).append("'");
                        break;
                    }
                }
                // 数据中sysSign不等于自己的stationId的 && 数据中stationId不等于连接池中的stationId
                addSql(sql.toString(), key, sysSign);
            }
        } catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
    }

    /**
     * 保存删除语句
     *
     * @param entry
     */
    private void saveDeleteSql(Entry entry) {
        try {
            RowChange rowChange = RowChange.parseFrom(entry.getStoreValue());
            List<RowData> rowDatasList = rowChange.getRowDatasList();
            for (RowData rowData : rowDatasList) {
                List<Column> columnList = rowData.getBeforeColumnsList();
                StringBuilder sql =
                        new StringBuilder("delete from " + entry.getHeader().getTableName() + " where ");

                boolean iskey = false;
                String key = null;
                String sysSign = null;
                for (Column column : columnList) {
                    String name = column.getName();
                    String value = column.getValue();
                    if ("station_id".equals(name)) {
                        key = value;
                    }
                    if ("sys_sign".equals(name)) {
                        sysSign = value;
                    }
                    if (column.getIsKey() && !iskey) {
                        // 暂时只支持单一主键
                        iskey = true;
                        sql.append(column.getName()).append(" = '").append(column.getValue()).append("'");
                    }
                }
                for (Map.Entry<String, ConcurrentLinkedQueue<String>> map : druidPool.entrySet()) {
                    map.getValue().add(sql.toString());
                }
            }
        } catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
    }


    /**
     * 保存插入语句
     *
     * @param entry
     */
    private void saveInsertSql(Entry entry) {
        try {
            RowChange rowChange = RowChange.parseFrom(entry.getStoreValue());
            List<RowData> rowDatasList = rowChange.getRowDatasList();
            for (RowData rowData : rowDatasList) {
                List<Column> columnList = rowData.getAfterColumnsList();
                StringBuilder sql = new StringBuilder();
                sql.append("insert into `").append(entry.getHeader().getTableName()).append("` (");
                StringBuilder values = new StringBuilder();
                values.append(") VALUES (");
                String key = null;
                String sysSign = null;
                for (int i = 0; i < columnList.size(); i++) {
                    String name = columnList.get(i).getName();
                    String value = columnList.get(i).getValue();

                    if ("station_id".equals(name)) {
                        key = value;
                    }
                    if ("sys_sign".equals(name)) {
                        sysSign = value;
                    }

                    sql.append("`").append(name).append("`");
                    if ("".equals(value)) {
                        values.append("null");
                    } else {
                        values.append("'").append(value).append("'");
                    }

                    if (i != columnList.size() - 1) {
                        sql.append(", ");
                        values.append(",");
                    }
                }
                values.append(")");
                addSql(sql.append(values).toString(), key, sysSign);
            }
        } catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
    }

    /**
     * 吧生成的SQL插入队列
     *
     * @param sql     sql
     * @param key     数据中的stationId
     * @param sysSign 数据中的sysSign
     */
    private void addSql(String sql, String key, String sysSign) {
        if (StringUtils.isNotBlank(key) && StringUtils.isNotBlank(sysSign)) {
            if (Constants.STRING_1.equals(type)) {
                //站点系统
                // 数据中stationId不等于连接池中的stationId
                for (Map.Entry<String, ConcurrentLinkedQueue<String>> map : druidPool.entrySet()) {
                    if (!map.getKey().equals(key) && !map.getKey().equals(sysSign)) {
                        map.getValue().add(sql);
                    }
                }
            } else if (Constants.STRING_2.equals(type) || Constants.STRING_3.equals(type)) {
                //线路/路网系统
                // 数据中的sysSign等于自己的stationId && 连接池中的stationId等于数据中的stationId
                for (Map.Entry<String, ConcurrentLinkedQueue<String>> map : druidPool.entrySet()) {
                    if (sysSign.equals(code) && map.getKey().equals(key)) {
                        map.getValue().add(sql);
                    }
                }
            }
        }
    }

    public void checkLink(String stationId) {
        errorLink.add(stationId);
        if (!errorLink.isEmpty() && errorLink.contains(stationId)) {
            ThreadPool.threadPoolExecutor.execute(() -> {
                int sta = 1;
                ConcurrentLinkedQueue<Boolean> queue = new ConcurrentLinkedQueue<>();
                while (true) {
                    if (queue.isEmpty() || queue.size() < 3) {
                        queue.offer(checkL(stationId));
                    } else {
                        if (queue.contains(false)) {
                            queue.poll();
                            queue.offer(checkL(stationId));
                        } else {
                            //执行SQL
                            if (runErrorSql(stationId)) {
                                sta = 2;
                                //执行成功后查询一次，看SQL是否过多
                                LambdaQueryWrapper<SysSynchDatalog> queryWrapper = new LambdaQueryWrapper<SysSynchDatalog>()
                                        .eq(SysSynchDatalog::getStationId, stationId)
                                        .eq(SysSynchDatalog::getStatus, Constants.INT_0)
                                        .orderByAsc(SysSynchDatalog::getCreateTime);
                                List<SysSynchDatalog> list = sysSynchDatalogService.list(queryWrapper);
                                if (list == null || list.size() <= 20) {
                                    //SQL比较少退出
                                    sta = 0;
                                }
                            } else {
                                //执行过程中出错
                                sta = 1;
                                queue.poll();
                                queue.offer(false);
                            }
                            if (sta == 0) {
                                queue.clear();
                                //当SQL数量少于20条，代表可以加入恢复列表
                                recoverLink.add(stationId);
                                break;
                            }
                        }
                    }
                    try {
                        if (sta == 1) {
                            Thread.sleep(1000);
                        }
                    } catch (InterruptedException ignored) {
                    }
                }
            });
        }
        //创建新线程执行遍历

        //1 如果链接ok就移除异常队列

        //2 如果异常队列为空就退出
    }

    /**
     * 测试链接是否能正常
     *
     * @param stationId 连接池的stationId，用这个来获取链接地址，然后解析出ip
     * @return 返回是否正常（true：正常 false：异常）
     */
    private boolean checkL(String stationId) {
        for (DruidUtils druidUtils : druidUtilsList) {
            if (stationId.equals(druidUtils.getStationId())) {
                String url = druidUtils.getUrl();
                String pattern = "((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}";
                Pattern r = Pattern.compile(pattern);
                Matcher m = r.matcher(url);
                if (m.find()) {
                    String group = m.group();
                    if (IPAddressUtil.isIPv4LiteralAddress(group)) {
                        Socket socket = new Socket();
                        try {
                            // 建立连接
                            socket.connect(new InetSocketAddress(group, 3306), 200);
                            return socket.isConnected();
                        } catch (IOException ignored) {
                        } finally {
                            try {
                                socket.close();   // 关闭连接
                            } catch (IOException ignored) {
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     * 执行链接异常时候产生的SQL
     *
     * @param stationId 链接异常的连接池stationId,用这个id来获取SQL
     * @return 执行完成（除了链接异常都属于执行完成）
     */
    public boolean runErrorSql(String stationId) {
        boolean allOk = true;
        LambdaQueryWrapper<SysSynchDatalog> queryWrapper = new LambdaQueryWrapper<SysSynchDatalog>()
                .eq(SysSynchDatalog::getStationId, stationId)
                .eq(SysSynchDatalog::getStatus, Constants.INT_0)
                .orderByAsc(SysSynchDatalog::getCreateTime);
        List<SysSynchDatalog> list = sysSynchDatalogService.list(queryWrapper);
        if (list == null || list.isEmpty()) {
            return true;
        }
        //查询当前连接池
        DruidUtils dru = null;
        for (DruidUtils druidUtils : druidUtilsList) {
            if (stationId.equals(druidUtils.getStationId())) {
                dru = druidUtils;
            }
        }
        for (SysSynchDatalog bean : list) {
            if (dru == null) {
                break;
            }
            String sql = bean.getSqlStr();
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            boolean execute = true;
            try {
                connection = dru.getConnection();
                preparedStatement = connection.prepareStatement(sql);
                try {
                    execute = preparedStatement.execute();
                } catch (SQLException throwable) {
                    //执行失败
                    //更新SQL状态为SQL异常
                    SysSynchDatalog sysSynchDatalog = new SysSynchDatalog();
                    sysSynchDatalog.setId(bean.getId());
                    sysSynchDatalog.setStatus(Constants.INT_2);
                    sysSynchDatalog.setUpdateTime(new Date());
                    sysSynchDatalogService.updateById(sysSynchDatalog);
                    System.out.println(throwable.toString());
                }
            } catch (SQLException ignored) {
                //链接失败
                allOk = false;
            } finally {
                if (!execute) {
                    //更新SQL状态为已执行
                    SysSynchDatalog sysSynchDatalog = new SysSynchDatalog();
                    sysSynchDatalog.setId(bean.getId());
                    sysSynchDatalog.setStatus(Constants.INT_1);
                    sysSynchDatalog.setUpdateTime(new Date());
                    sysSynchDatalogService.updateById(sysSynchDatalog);
                    System.out.println("第二次SQL执行成功！");
                } else {
                    //启动异常服务监控
                    System.out.println("第二次SQL执行失败！");
                }
                System.out.println("\t" + sql);
                dru.close(preparedStatement, connection);
            }
            if (!allOk) {
                break;
            }
        }
        return allOk;
    }

}
