package com.devplatform.transfer.canal;

import com.devplatform.transfer.common.util.Constants;
import com.devplatform.transfer.common.util.DruidUtils;
import com.devplatform.transfer.common.util.ThreadPool;
import com.devplatform.transfer.modules.datasource.bean.SysDatasource;
import com.devplatform.transfer.modules.datasource.service.SysDatasourceService;
import com.devplatform.transfer.modules.syssystem.bean.SysSystem;
import com.devplatform.transfer.modules.syssystem.serive.SysSystemService;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

/**
 * 数据同步
 *
 * @author Muceball
 * @date 2020/10/26
 */
@Component
@Order(2)
public class SqlRunner implements CommandLineRunner {

    @Resource
    private ExecuteSql executeSql;
    @Autowired
    private SysDatasourceService sysDatasourceService;
    @Autowired
    private SysSystemService sysSystemService;

    @Override
    public void run(String... args) throws Exception {
        List<DruidUtils> druidUtilsList = new ArrayList<>();
        // 获取数据源
        List<SysDatasource> list = sysDatasourceService.list(null);
        for (SysDatasource sysDatasource : list) {
            DruidUtils druidUtils = new DruidUtils(
                    sysDatasource.getDetail(),
                    sysDatasource.getUrl(),
                    sysDatasource.getUsername(),
                    sysDatasource.getPassword(),
                    sysDatasource.getStationId());
            druidUtilsList.add(druidUtils);
        }
        if (druidUtilsList.isEmpty()) {
            throw new Exception("未读取到数据库配置！");
        }
        System.out.println("******************************************");
        druidUtilsList.forEach(System.out::println);
        System.out.println("******************************************");

        SysSystem one = sysSystemService.getById(Constants.STRING_1);
        if (one == null || StringUtils.isBlank(one.getId()) || StringUtils.isBlank(one.getType()) || StringUtils.isBlank(one.getCode())) {
            throw new Exception("系统参数未设置！");
        }
        // 项目启动，执行canal客户端监听
        ThreadPool.threadPoolExecutor.execute(() -> executeSql.run(druidUtilsList, one));
    }
}
