package com.devplatform.transfer.common.util;

import com.alibaba.druid.pool.DruidDataSourceFactory;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.sql.DataSource;

/**
 * @author Administrator
 */
public class DruidUtils {
    private String name;
    private String url;
    private String username;
    private String password;
    private int initialSize = 0;
    private int maxActive = 20;
    private String stationId;
    private DataSource ds;

    public DruidUtils(String name, String url, String username, String password, String stationId) {
        this.name = name;
        this.url = url;
        this.username = username;
        this.password = password;
        this.stationId = stationId;
        HashMap<String, Object> map = new HashMap<>();
        map = setParams(map, name, url, username, password);
        try {
            ds = DruidDataSourceFactory.createDataSource(map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DruidUtils(String name, String url, String username, String password, int initialSize, int maxActive, String stationId) {
        this.name = name;
        this.url = url;
        this.username = username;
        this.password = password;
        this.initialSize = initialSize;
        this.stationId = stationId;
        this.maxActive = maxActive;
        HashMap<String, Object> map = new HashMap<>();
        map = setParams(map, name, url, username, password, initialSize, maxActive);
        try {
            ds = DruidDataSourceFactory.createDataSource(map);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 设置参数
     * @param map
     * @param name
     * @param url
     * @param username
     * @param password
     * @param initialSize
     * @param maxActive
     * @return
     */
    HashMap<String, Object> setParams(HashMap<String, Object> map, String name, String url, String username, String password, int initialSize, int maxActive) {
        map.put("name", name);
        map.put("url", url);
        map.put("username", username);
        map.put("password", password);
        map.put("initialSize", initialSize);
        map.put("maxActive", maxActive);
        //获取连接等待超时的时间
        map.put("maxWait", "3000");

        return map;
    }

    HashMap<String, Object> setParams(HashMap<String, Object> map, String name, String url, String username, String password) {
        map.put("name", name);
        map.put("url", url);
        map.put("username", username);
        map.put("password", password);
        //获取连接等待超时的时间
        map.put("maxWait", "3000");
        return map;
    }

    /**
     * 获取连接池对象
     * @return
     */
    public DataSource getDataSource() {
        return ds;
    }

    /**
     * 获取连接Connection对象
     * @return
     * @throws SQLException
     */
    public Connection getConnection() throws SQLException {
        return ds.getConnection();
    }

    /**
     * 释放资源
     * @param stmt
     * @param conn
     */
    public void close(Statement stmt, Connection conn) {
        close(null, stmt, conn);
    }

    /**
     * 释放资源
     * @param rs
     * @param stmt
     * @param conn
     */
    public void close(ResultSet rs, Statement stmt, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close(); // 归还连接
            } catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getInitialSize() {
        return initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public int getMaxActive() {
        return maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public String getStationId() {
        return stationId;
    }

    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    @Override
    public String toString() {
        return "DruidUtils{" +
                "name='" + name + '\'' +
                ", url='" + url + '\'' +
                ", username='" + username + '\'' +
                ", password='" + password + '\'' +
                ", initialSize=" + initialSize +
                ", maxActive=" + maxActive +
                ", stationId='" + stationId + '\'' +
                '}';
    }
}
