package com.devplatform.transfer.feign.config;

import feign.Request;
import feign.Retryer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author Administrator
 */
@Configuration
public class FeignConfigure {
    /** 超时时间*/
    public static int connectTimeOutMillis = 12000;
    public static int readTimeOutMillis = 12000;

    @Bean
    public Request.Options options() {
        return new Request.Options(connectTimeOutMillis, readTimeOutMillis);
    }

    /**
     * 自定义重试次数
     *
     * @return
     */
    @Bean
    public Retryer feignRetryer() {
    /* period=100 发起当前请求的时间间隔，单位毫秒
    // maxPeriod=1000 发起当前请求的最大时间间隔，单位毫秒
    // maxAttempts=5 最多请求次数，包括第一次
     */
        Retryer retryer = new Retryer.Default(100, 1000, 5);
        return retryer;
    }
}
