package com.devplatform.transfer.modules.datasource.bean;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * @author Administrator
 */
@ApiModel(value = "数据源管理对象", description = "数据源管理对象")
@TableName("sys_datasource")
public class SysDatasource implements Serializable {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID", name = "id")
    @TableId
    /** 主键id*/
    private String id;

    @ApiModelProperty(value = "数据源url（包含地址端口以及参数）", name = "url")
    /** 数据源url（包含地址端口以及参数）*/
    private String url;

    @ApiModelProperty(value = "用户名", name = "user")
    /** 用户名*/
    private String username;

    @ApiModelProperty(value = "密码", name = "password")
    /** 密码*/
    private String password;

    @ApiModelProperty(value = "数据源服务器ip", name = "ip")
    /** 数据源服务器ip*/
    private String ip;

    @ApiModelProperty(value = "数据源端口", name = "port")
    /** 数据源端口*/
    private String port;

    @ApiModelProperty(value = "说明信息", name = "explain")
    /** 说明信息*/
    private String detail;

    @ApiModelProperty(value = "数据源类型（1、mysql  2、oracle）", name = "type")
    /** 数据源类型（1、mysql  2、oracle）*/
    private Integer type;

    @ApiModelProperty(value = "是否已删除(0未删除，1已删除)", name = "deleted")
    /** 是否已删除(0未删除，1已删除)*/
    private Integer deleted;

    @ApiModelProperty(value = "创建人", name = "createUserId")
    /** 创建人*/
    private String createUserId;

    @ApiModelProperty(value = "创建时间", name = "createTime")
    /** 创建时间*/
    private java.util.Date createTime;

    @ApiModelProperty(value = "修改人", name = "updateUserId")
    /** 修改人*/
    private String updateUserId;

    @ApiModelProperty(value = "修改时间", name = "updateTime")
    /** 修改时间*/
    private java.util.Date updateTime;

    @ApiModelProperty(value = "备用项1", name = "byx1")
    /** 备用项1*/
    private String byx1;

    @ApiModelProperty(value = "备用项2", name = "byx2")
    /** 备用项2*/
    private String byx2;

    @ApiModelProperty(value = "备用项3", name = "byx3")
    /** 备用项3*/
    private String byx3;

    @ApiModelProperty(value = "系统标识", name = "sysSign")
    /** 系统标识*/
    private String sysSign;

    private String stationId;

    public String getStationId() {
        return stationId;
    }

    public void setStationId(String stationId) {
        this.stationId = stationId;
    }

    public String getSysSign() {
        return sysSign;
    }

    public void setSysSign(String sysSign) {
        this.sysSign = sysSign;
    }

    /**
     * 主键id的getter方法
     */
    public String getId() {
        return id;
    }

    /**
     * 主键id的setter方法
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 数据源url（包含地址端口以及参数）的getter方法
     */
    public String getUrl() {
        return url;
    }

    /**
     * 数据源url（包含地址端口以及参数）的setter方法
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * 用户名的getter方法
     */
    public String getUsername() {
        return username;
    }

    /**
     * 用户名的setter方法
     */
    public void setUsername(String username) {
        this.username = username;
    }

    /**
     * 密码的getter方法
     */
    public String getPassword() {
        return password;
    }

    /**
     * 密码的setter方法
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * 数据源服务器ip的getter方法
     */
    public String getIp() {
        return ip;
    }

    /**
     * 数据源服务器ip的setter方法
     */
    public void setIp(String ip) {
        this.ip = ip;
    }

    /**
     * 数据源端口的getter方法
     */
    public String getPort() {
        return port;
    }

    /**
     * 数据源端口的setter方法
     */
    public void setPort(String port) {
        this.port = port;
    }

    /**
     * 说明信息的getter方法
     */
    public String getDetail() {
        return detail;
    }

    /**
     * 说明信息的setter方法
     */
    public void setDetail(String detail) {
        this.detail = detail;
    }

    /**
     * 数据源类型（1、mysql 2、oracle）的getter方法
     */
    public Integer getType() {
        return type;
    }

    /**
     * 数据源类型（1、mysql 2、oracle）的setter方法
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 是否已删除(0未删除，1已删除)的getter方法
     */
    public Integer getDeleted() {
        return deleted;
    }

    /**
     * 是否已删除(0未删除，1已删除)的setter方法
     */
    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    /**
     * 创建人的getter方法
     */
    public String getCreateUserId() {
        return createUserId;
    }

    /**
     * 创建人的setter方法
     */
    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    /**
     * 创建时间的getter方法
     */
    public java.util.Date getCreateTime() {
        return createTime;
    }

    /**
     * 创建时间的setter方法
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 修改人的getter方法
     */
    public String getUpdateUserId() {
        return updateUserId;
    }

    /**
     * 修改人的setter方法
     */
    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    /**
     * 修改时间的getter方法
     */
    public java.util.Date getUpdateTime() {
        return updateTime;
    }

    /**
     * 修改时间的setter方法
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 备用项1的getter方法
     */
    public String getByx1() {
        return byx1;
    }

    /**
     * 备用项1的setter方法
     */
    public void setByx1(String byx1) {
        this.byx1 = byx1;
    }

    /**
     * 备用项2的getter方法
     */
    public String getByx2() {
        return byx2;
    }

    /**
     * 备用项2的setter方法
     */
    public void setByx2(String byx2) {
        this.byx2 = byx2;
    }

    /**
     * 备用项3的getter方法
     */
    public String getByx3() {
        return byx3;
    }

    /**
     * 备用项3的setter方法
     */
    public void setByx3(String byx3) {
        this.byx3 = byx3;
    }
}
