package com.devplatform.transfer.modules.datasource.controller;

import com.devplatform.common.util.R;
import com.devplatform.transfer.modules.datasource.bean.SysDatasource;
import com.devplatform.transfer.modules.datasource.service.SysDatasourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author Administrator
 */
@Api(tags = {"数据源管理接口"})
@RestController
@RequestMapping("/sysDatasource")
public class SysDatasourceController {

    @Autowired
    private Environment env;

    @Autowired
    private SysDatasourceService sysDatasourceService;

    /**
     * 列表页面列表数据获取
     *
     * @param params 承接对象
     * @return
     */
    @ApiOperation(value = "根据条件获取数据源管理分页数据列表", notes = "根据条件获取数据源管理分页数据列表")
    @ApiImplicitParam(
            name = "params",
            value = "参数",
            required = true,
            dataType = "Map<String, Object>")
    @PostMapping("/list")
    public List<SysDatasource> list(@RequestBody Map<String, Object> params) {
        ////        PageUtils page = sysDatasourceService.queryPage(params, null);
        //        Integer page = (Integer) params.get("page");
        //        Integer size = (Integer) params.get("size");
        //        if (page != null && size != null) {
        //            Page<SysDatasource> result = sysDatasourceService.getListPage(new
        // Page<SysDatasource>(page, size), params);
        //            return R.ok().put("page", result);
        //        } else {
        //            List<SysDatasource> list = sysDatasourceService.getList(params);
        //            return R.ok().put("list", list);
        //        }
        return sysDatasourceService.getList(params);
    }

    /**
     * 获取配置文件信息
     */
    @GetMapping("/getProperty")
    public R getProperty(String... name) {
        if (name.length == 0) {
            return R.error("请输入你要获取的参数名称");
        }
        HashMap<String, String> map = new HashMap<>(10);
        for (String s : name) {
            map.put(s, env.getProperty(s));
        }
        return R.ok().put("property", map);
    }
}
