package com.devplatform.transfer.modules.syssystem.controller;

import com.devplatform.common.util.PageUtils;
import com.devplatform.common.util.R;
import com.devplatform.transfer.modules.syssystem.serive.RtSysSystemService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
/**
 * @author Administrator
 */
@Api(tags = {"系统标识表接口"})
@RestController
@RequestMapping("/routes/sysSystem")
public class RtSysSystemController {

  @Autowired private RtSysSystemService rtSysSystemService;

  /**
   * 列表页面列表数据获取
   *
   * @param params 承接对象
   * @return
   */
  @ApiOperation(value = "根据条件获取系统标识表分页数据列表", notes = "根据条件获取系统标识表分页数据列表")
  @ApiImplicitParam(
      name = "params",
      value = "参数",
      required = true,
      dataType = "Map<String, Object>")
  @PostMapping("/list")
  public R list(@RequestParam Map<String, Object> params) {
    PageUtils page = rtSysSystemService.queryPage(params, null);
    return R.ok().put("page", page);
  }
}
