package com.devplatform.admin.common.scheduling;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.modules.eq.bean.TimedTask;
import com.devplatform.admin.modules.eq.controller.EquipmentController;
import com.devplatform.admin.modules.eq.service.TimedTaskService;
import com.devplatform.admin.modules.sys.bean.SysSystemParams;
import com.devplatform.admin.modules.sys.service.SysSystemParamsService;
import com.devplatform.common.util.R;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author dxw
 */
@Component
@Order(2)
public class InitRunner implements CommandLineRunner {
    @Autowired
    private TimedTaskService timedTaskService;
    @Autowired
    private SysSystemParamsService sysSystemParamsService;
    @Autowired
    private EquipmentController equipmentController;

    @Override
    public void run(String... args) throws Exception {
        try {
            SysSystemParams sysSystemParams = sysSystemParamsService.getOne(new LambdaQueryWrapper<SysSystemParams>().last("limit 1"));
            // 获取定时任务信息
            List<TimedTask> timedTasks = timedTaskService.list(new LambdaQueryWrapper<TimedTask>().eq(TimedTask::getStatus,Constants.INT_1));
            if(timedTasks != null && timedTasks.size() > 0){
                for(TimedTask timedTask : timedTasks){
                    //人工模式
                    if(sysSystemParams.getType() == 1 && timedTask.getBusinessType() != Constants.INT_3) {
//                        R r = equipmentController.timedTask(timedTask.getId(), timedTask.getStartTime(), timedTask.getEndTime(), Constants.INT_1,
//                                timedTask.getBusinessType(), timedTask.getType(), Constants.STRING_1,Constants.INT_3);
//                        if (!Constants.STRING_0.equals(r.get(Constants.CODE_WORD).toString())) {
//                            System.err.println("定时任务启动失败！！");
//                        }
                    } else if(sysSystemParams.getType() == 2 && timedTask.getBusinessType() == Constants.INT_3) {
                        //开启节能大小循环
                        R r = equipmentController.timedTask(timedTask.getId(), timedTask.getStartTime(), timedTask.getEndTime(), Constants.INT_1,
                                timedTask.getBusinessType(), timedTask.getType(), Constants.STRING_1,timedTask.getBusinessSonType());
                        if (!Constants.STRING_0.equals(r.get(Constants.CODE_WORD).toString())) {
                            System.err.println("定时任务启动失败！！");
                        }
                    }
                }
            }
        } catch (Exception e) {
            System.err.println("定时任务启动失败！");
            e.printStackTrace();
        }
    }
}
