package com.devplatform.admin.common.scheduling;

import com.alibaba.fastjson.JSONObject;
import com.devplatform.admin.common.utils.Constants;
import com.devplatform.admin.common.utils.TestClient;
import org.quartz.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @author dxw
 * @date 2021/4/9
 */
public class SimpleJob implements Job {
    private static Logger LOG = LoggerFactory.getLogger(SimpleJob.class);
    @Override
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobKey jobKey = context.getJobDetail().getKey();
        LOG.info("执行任务。SimpleJob says: " + jobKey + " executing at " + new Date());

        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        Integer status = (Integer) jobDataMap.get("status");
        Integer type = (Integer) jobDataMap.get("type");
        Integer businessType = (Integer) jobDataMap.get("businessType");
        Integer businessSonType = (Integer) jobDataMap.get("businessSonType");

        Map<String, String> postParam = new HashMap<String, String>(10);

        if(businessType == Constants.INT_1){
            LOG.info("执行定时启停任务");
            String postUrl = "http://localhost:8089/command/startOrStopTask";
            postParam.put("params",status.toString());
            postParam.put("actionType",Constants.STRING_1);

            Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
            Map<String, Object> map = null;
            if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
                map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
            }
        }else if(businessType == Constants.INT_2){
            //type  1:上升  2:下降
            if(type == Constants.INT_1){

            }else {

            }
        }else if(businessType == Constants.INT_3){
            LOG.info("执行节能任务");
            if(businessSonType==Constants.INT_1){
                String postUrl = "http://localhost:8089/command/energyTask";
                Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
                Map<String, Object> map = null;
                if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
                    map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
                }
            }else if(businessSonType == Constants.INT_2){
                String postUrl = "http://localhost:8089/command/energyTask2";
                Map<String, Object> resultMap = TestClient.uploadText(postUrl, postParam);
                Map<String, Object> map = null;
                if (Constants.STRING_200.equals(resultMap.get(Constants.STATUS_CODE).toString())) {
                    map = JSONObject.parseObject(resultMap.get("data").toString(), Map.class);
                }
            }

        }
    }
}
