package com.devplatform.admin.common.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

/**
 * @author Administrator
 */
public class ExportExcel {
  /** 显示的导出表的标题 */
  private String title;
  /** 导出表的列名 */
  private List<String> rowName;
  private List<PageData> varList1;

  /** 构造函数，传入要导出的数据 */
  public ExportExcel(Map<String, Object> model) {
    this.varList1 = (List<PageData>) model.get("varList");
    this.rowName = (List<String>) model.get("titles");
    this.title = (String) model.get("title");
  }

  /**
   * 导出数据
    * @param out
   * @throws Exception
   */
  public void export(OutputStream out) throws Exception {
    try {
      Workbook workbook = new XSSFWorkbook();
      Sheet sheet = workbook.createSheet(title);
      DataValidationHelper dvHelper = sheet.getDataValidationHelper();

      // sheet样式定义【】
      CellStyle columnTopStyle = this.getColumnTopStyle(workbook);
      CellStyle style = this.getStyle(workbook);

      // 定义所需列数
      int columnNum = rowName.size();
      Row rowRowName = sheet.createRow(0);

      // 将列头设置到sheet的单元格中
      for (int n = 0; n < columnNum; n++) {
        Cell cellRowName = rowRowName.createCell(n, CellType.STRING);
        cellRowName.setCellValue(rowName.get(n));
        cellRowName.setCellStyle(columnTopStyle);
      }

      // 将查询到的数据设置到sheet对应的单元格中
      for (int i = 0; i < varList1.size(); i++) {
        // 遍历每个对象
        PageData vpd = varList1.get(i);
        // 创建所需的行数
        Row row = sheet.createRow(i + 1);
        for (int j = 0; j < columnNum; j++) {
          Cell cell = null;
          @SuppressWarnings("unchecked")
          String varstr =
              vpd.getString("var" + (j + 1)) != null ? vpd.getString("var" + (j + 1)) : "";
          cell = row.createCell(j, CellType.STRING);
          cell.setCellValue(varstr);
          cell.setCellStyle(style);
        }
      }
      sheet.setDefaultColumnWidth(10);

      if (workbook != null) {
        try {
          workbook.write(out);
        } catch (Exception e) {
          e.printStackTrace();
        } finally {
          try {
            out.close();
          } catch (IOException e) {
            e.printStackTrace();
          }
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * 列头单元格样式
   * @param workbook
   * @return
   */
  public CellStyle getColumnTopStyle(Workbook workbook) {
    // 设置字体
    Font font = workbook.createFont();

    // 设置字体大小
    font.setFontHeightInPoints((short) 11);
    // 字体加粗
    font.setBold(false);
    // 设置字体名字
    font.setFontName("宋体");
    // 设置样式
    CellStyle style = workbook.createCellStyle();
    // 在样式中应用设置的字体
    style.setFont(font);
    // 设置自动换行
    style.setWrapText(true);
    // 设置水平对齐的样式为居中对齐；
    style.setAlignment(HorizontalAlignment.CENTER);
    style.setVerticalAlignment(VerticalAlignment.CENTER);
    return style;
  }

  public CellStyle getStyle(Workbook workbook) {
    // 设置字体
    Font font = workbook.createFont();
    // 设置字体大小
    font.setFontHeightInPoints((short) 11);
    // 字体加粗
    font.setBold(false);
    // 设置字体名字
    font.setFontName("宋体");
    // 设置样式;
    CellStyle style = workbook.createCellStyle();
    // 在样式用应用设置的字体;
    style.setFont(font);
    // 设置自动换行;
    style.setWrapText(false);
    // 设置水平对齐的样式为居中对齐;
    style.setAlignment(HorizontalAlignment.LEFT);
    // 设置垂直对齐的样式为居中对齐;
    style.setVerticalAlignment(VerticalAlignment.CENTER);
    return style;
  }
}
