package com.devplatform.admin.common.utils;

import com.devplatform.admin.modules.eq.bean.SwqxzInfoHour;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author Administrator
 */
public class ExportSwqxzExcel {
  /** 显示的导出表的标题 */
  private String title;
  /** 导出表的列名 */
  private List<String> rowName;
  private List<SwqxzInfoHour> varList;

  /** 构造函数，传入要导出的数据 */
  public ExportSwqxzExcel(Map<String, Object> model) {
    this.varList = (List<SwqxzInfoHour>) model.get("list");
    this.rowName = (List<String>) model.get("titles");
    this.title = (String) model.get("title");
  }

  /**
   * 导出数据
    * @param out
   */
  public void export(OutputStream out) {
    try {
      Workbook workbook = new XSSFWorkbook();
      Sheet sheet = workbook.createSheet(title);
      // sheet样式定义【】
      CellStyle columnTopStyle = this.getColumnTopStyle(workbook);
      CellStyle style = this.getStyle(workbook);

      // 定义所需列数
      int columnNum = rowName.size();
      Row rowRowName = sheet.createRow(0);
      sheet.setDefaultColumnWidth(18);

      // 将列头设置到sheet的单元格中
      for (int n = 0; n < columnNum; n++) {
        Cell cellRowName = rowRowName.createCell(n, CellType.STRING);
        cellRowName.setCellValue(rowName.get(n));
        cellRowName.setCellStyle(columnTopStyle);
      }

      if(varList != null && varList.size() > 0) {
        for (int i = 0; i < varList.size(); i++) {
          Row rowRowName2 = sheet.createRow(i+1);
          List<String> strList2 = new ArrayList<>();
          //序号
          strList2.add((i+1)+"");
          strList2.add(varList.get(i).getName());
          strList2.add(varList.get(i).getCode());
          strList2.add(varList.get(i).getTemperature());
          strList2.add(varList.get(i).getHumidity());
          strList2.add(varList.get(i).getWindSpeed());
          strList2.add(varList.get(i).getIlluminance());
          strList2.add(varList.get(i).getCarbonDioxide());
          strList2.add(varList.get(i).getFineParticles());
          strList2.add(varList.get(i).getRadiation());
          strList2.add(DateUtil.getPlusTime(varList.get(i).getCreateTime()));
          // 将列头设置到sheet的单元格中
          for (int n = 0; n < columnNum; n++) {
            Cell cellRowName = rowRowName2.createCell(n, CellType.STRING);
            cellRowName.setCellValue(strList2.get(n));
            cellRowName.setCellStyle(columnTopStyle);
          }
        }
      }

      if (workbook != null) {
        try {
          workbook.write(out);
        } catch (Exception e) {
          e.printStackTrace();
        } finally {
          try {
            out.close();
          } catch (IOException e) {
            e.printStackTrace();
          }
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * 列头单元格样式
   * @param workbook
   * @return
   */
  public CellStyle getColumnTopStyle(Workbook workbook) {
    // 设置字体
    Font font = workbook.createFont();

    // 设置字体大小
    font.setFontHeightInPoints((short) 12);
    // 字体加粗
    font.setBold(false);
    // 设置字体名字
    font.setFontName("宋体");
    // 设置样式
    CellStyle style = workbook.createCellStyle();
    // 在样式中应用设置的字体
    style.setFont(font);
    // 设置自动换行
    style.setWrapText(true);
    // 设置水平对齐的样式为居中对齐；
    style.setAlignment(HorizontalAlignment.CENTER);
    style.setVerticalAlignment(VerticalAlignment.CENTER);
    return style;
  }

  public CellStyle getStyle(Workbook workbook) {
    // 设置字体
    Font font = workbook.createFont();
    // 设置字体大小
    font.setFontHeightInPoints((short) 11);
    // 字体加粗
    font.setBold(false);
    // 设置字体名字
    font.setFontName("宋体");
    // 设置样式;
    CellStyle style = workbook.createCellStyle();
    // 在样式用应用设置的字体;
    style.setFont(font);
    // 设置自动换行;
    style.setWrapText(false);
    // 设置水平对齐的样式为居中对齐;
    style.setAlignment(HorizontalAlignment.LEFT);
    // 设置垂直对齐的样式为居中对齐;
    style.setVerticalAlignment(VerticalAlignment.CENTER);
    return style;
  }

}
