package com.devplatform.admin.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;

/**
 * httpURLconnection的接口方法调用
 * @author Administrator
 */
public class HttpUtil {

  /**
   * get的方式
   * @param path
   * @param authorization
   * @return
   */
  public static String executeGetMethod(String path, String authorization) {
    String response = "";
    try {
      URL url = new URL(path);
      HttpURLConnection connection = (HttpURLConnection) url.openConnection();

      connection.setRequestProperty("Authorization", "Basic " + authorization);
      connection.setRequestMethod("GET");
      connection.setConnectTimeout(5000);
      connection.setReadTimeout(5000);
      connection.connect();

      // 获得返回值
      InputStream in = connection.getInputStream();
      response = getResponse(in);
      System.out.println("response" + response);

      connection.disconnect();
    } catch (MalformedURLException e) {
      e.printStackTrace();
    } catch (UnsupportedEncodingException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return response;
  }

  /**
   * Post的方式
   * @param path
   * @param paramStr
   * @return
   * @throws SocketTimeoutException
   */
  public static String executePostMethod(String path, String paramStr)
      throws SocketTimeoutException {
    String response = "";
    try {
      URL url = new URL(path);
      HttpURLConnection connection = (HttpURLConnection) url.openConnection();

      connection.setRequestMethod("POST");
      connection.setDoInput(true);
      connection.setDoOutput(true);
      connection.setUseCaches(false);
      connection.setConnectTimeout(5000);
      connection.setRequestProperty("Charset", "UTF-8");
      connection.setRequestProperty("Content-Length", String.valueOf(paramStr.length()));
      connection.setRequestProperty("Content-Type", "application/json");
      connection.connect();

      OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");
      // 写入请求的字符串
      out.write(paramStr);
      out.flush();
      out.close();

      // 获得返回值
      InputStream in = connection.getInputStream();
      response = getResponse(in);

      connection.disconnect();
    } catch (SocketTimeoutException e) {
      throw e;
    } catch (MalformedURLException e) {
      e.printStackTrace();
    } catch (UnsupportedEncodingException e) {
      e.printStackTrace();
    } catch (IOException e) {
      e.printStackTrace();
    }
    return response;
  }

  private static String getResponse(InputStream in) {
    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
    StringBuilder builder = new StringBuilder();
    String line;
    try {
      while ((line = reader.readLine()) != null) {
        builder.append(line);
      }
    } catch (IOException e) {
      e.printStackTrace();
    } finally {
      try {
        reader.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return builder.toString();
  }
}
