package com.devplatform.admin.common.utils;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

/**
 * rabbitmq服务提供类
 * @author 
 */
public class RabbitMqProvider {
	private Logger logger = LoggerFactory.getLogger(this.getClass());

	/**
	 * RabbitMq消息发送
	 * 系统收到设备传递的报警信息，整理成json串后，统一发送至消息队列
	 * @param message	JSON消息
	 * @return	result true=发送成功,false=发送失败
	 */
	public boolean sendMsg(String message,String host,String username,String password,int port,String virtualHost,String stationId) {
		System.out.println("host:" + host);
		boolean result = true;
		try {
			//创建连接
			ConnectionFactory factory = new ConnectionFactory();
			//Rabbit服务器地址
			factory.setHost(host);
			//账号
			factory.setUsername(username);
			//密码
			factory.setPassword(password);

			factory.setVirtualHost(virtualHost);
			//端口
			factory.setPort(port);
			//新建连接
			Connection connection = factory.newConnection();
			//建立通道
			Channel channel = connection.createChannel();
			//设置连接参数
			channel.queueDeclare(Constants.QUEUE_NAME + stationId, false, false, false, null);
			//消息push
			channel.basicPublish("", Constants.QUEUE_NAME + stationId, null, message.getBytes());
			logger.info(" [x] Sent '" + message + "'");
			channel.close(); //通道关闭
			connection.close();//连接关闭
		} catch (Exception e) {
			result = false;
			e.printStackTrace();
		}
		return result;
	}
}

