package com.devplatform.admin.common.utils;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import ch.ethz.ssh2.StreamGobbler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
/**
 * @author jzj
 * @date 2020/6/15 18:26
 */
public class ShhUtils {
  private Session ssh;
  private String hostName;
  private String userName;
  private String password;
  private int port;

  /**
   * 连接服务器
   *
   * @param hostname 服务器IP
   * @param port 端口
   * @param username 账号
   * @param password 密码
   */
  public ShhUtils(String hostname, int port, String username, String password) {
    this.hostName = hostname;
    this.port = port;
    this.userName = username;
    this.password = password;
    // this.log = Logger.getLogger(LogAuto.class);
  }

  /**
   * 功能：获取指定服务器在当前时间的内存使用率
   *
   * @param shhUtils
   * @return 返回内存大小和使用率（百分比）
   */
  public static List<Object> getMemoryRate(ShhUtils shhUtils) {
    List<Object> result = new ArrayList<>();
    // 多个命令用“;”隔开
    String shell = String.format("%s", "free;top -bn1 -i");
    List<String> listResult = shhUtils.execCom(shell);
    System.out.println(LocalDateTime.now());

    // 提取内存数据（第二行）
    List<String> mem = Arrays.asList(listResult.get(1).split("\\s+"));
    double usedMemory = Integer.valueOf(mem.get(2));
    double allMemory = Integer.valueOf(mem.get(1));

    // 计算内存使用率（已使用内存/总内存）
    double f1 =
        new BigDecimal((float) usedMemory / allMemory)
                .setScale(2, BigDecimal.ROUND_HALF_UP)
                .doubleValue()
            * 100;
    result.add(Math.ceil(allMemory / (1024 * 1024)));
    result.add(f1);
    return result;
  }

  /**
   * 获取cpu和内存大小和使用情况
   *
   * @param shhUtils
   * @return
   */
  public static List<Object> getCpuTop(ShhUtils shhUtils) {
    List<Object> list = new ArrayList<>();
    // 多个命令用“;”隔开
    String shell = String.format("%s", "top -bn 1 -i -c");
    List<String> listResult = shhUtils.execCom(shell);
    // 打印shell命令执行后的结果
    double cpuUsed = 0d;
    List<String> mem = Arrays.asList(listResult.get(2).trim().split("\\s+"));
    cpuUsed =
        Double.parseDouble(mem.get(1).replace("%us,", ""))
            + Double.parseDouble(mem.get(2).replace("%sy,", ""));
    list.add(String.format("%.1f", cpuUsed));
    List<String> mem2 = Arrays.asList(listResult.get(3).trim().split("\\s+"));
    // 已使用的内存
    double usedMemory = Integer.valueOf(mem2.get(3).replace("k", ""));
    // 全部内存
    double allMemory = Integer.valueOf(mem2.get(1).replace("k", ""));

    // 计算内存使用率（已使用内存/总内存）
    double f1 =
        new BigDecimal((float) usedMemory / allMemory)
                .setScale(2, BigDecimal.ROUND_HALF_UP)
                .doubleValue()
            * 100;
    list.add((allMemory / (1024 * 1024)));
    list.add(f1);
    return list;
  }

  /**
   * 获取磁盘大小和使用率
   *
   * @param shhUtils
   * @return
   */
  public static List<Object> getDiskRate(ShhUtils shhUtils) {
    List<Object> result = new ArrayList<>();
    // 多个命令用“;”隔开
    String shell = String.format("%s", "df -hl");
    List<String> listResult = shhUtils.execCom(shell);
    double usedDisk = 0d;
    double allDisk = 0d;
    for (int i = 1; i < listResult.size(); i++) {
      // 提取内存数据（第二行）
      List<String> mem = Arrays.asList(listResult.get(i).split("\\s+"));
      usedDisk += Double.parseDouble(mem.get(4).replace("%", ""));
      allDisk += Double.parseDouble(mem.get(1).replace("G", ""));
    }
    result.add(allDisk);
    // 计算内存使用率（已使用内存/总内存）
    result.add(usedDisk);
    return result;
  }

  /**
   * 获取核心数
   *
   * @param shhUtils
   * @return
   */
  public static String getCoreCount(ShhUtils shhUtils) {
    List<String> result = new ArrayList<>();
    // 多个命令用“;”隔开
    String shell = String.format("%s", "cat /proc/cpuinfo| grep \"cpu cores\"| uniq");
    List<String> listResult = shhUtils.execCom(shell);
    return listResult.get(0).replace("cpu cores\t: ", "");
  }

  /**
   * 获取系统基本信息
   *
   * @param shhUtils
   * @return
   */
  public static List<String> getSystemInfo(ShhUtils shhUtils) {
    List<String> result = new ArrayList<>();
    // 多个命令用“;”隔开
    String shell =
        String.format(
            "%s",
            "uname;uname -n;cat /proc/cpuinfo| grep \"cpu cores\"| uniq;cat /proc/cpuinfo | grep name");
    List<String> listResult = shhUtils.execCom(shell);
    listResult.set(2, listResult.get(2).replace("cpu cores\t: ", ""));
    listResult.set(3, listResult.get(3).replace("model name\t: ", ""));
    return listResult;
  }

  public static List<String> getTest(ShhUtils shhUtils) {
    String shell =
        String.format(
            "free;top -bn1 -i;df -hl;uname;uname -n;cat /proc/cpuinfo |grep \\\"cores\\\"|uniq;cat /proc/cpuinfo | grep name");
    return null;
  }

  public static void main(String[] args) {
    // ShhUtils shhUtils = new ShhUtils("47.94.207.62", 22, "root", "TeSt1234");
    ShhUtils shhUtils = new ShhUtils("59.110.43.122", 22, "root", "Test1234");
    System.out.println(getCpuTop(shhUtils));
  }

  /**
   * 通过Linux命令查询日志内容
   *
   * @param command Linux日志查询命令
   * @return 返回根据命令查出的日志内容
   */
  public List<String> execCom(String command) {
    Connection conn = new Connection(this.hostName, this.port);
    createConnection(conn);
    List<String> logContent = new ArrayList<String>();
    try {
      ssh.execCommand(command);
    } catch (IOException e) {
      e.printStackTrace();
    }

    // 将Terminal屏幕上的文字全部打印出来
    InputStream is = new StreamGobbler(ssh.getStdout());
    BufferedReader brs = new BufferedReader(new InputStreamReader(is));
    while (true) {
      String line = null;
      try {
        line = brs.readLine();
      } catch (IOException e) {
        e.printStackTrace();
      }
      if (line == null) {
        break;
      }
      logContent.add(line);
    }

    return logContent;
  }

  private void createConnection(Connection connection) {
    // 创建连接
    try {
      connection.connect();
      connection.authenticateWithPassword(this.userName, this.password);
      // 创建与服务器的会话节点
      setSsh(connection.openSession());
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  private Session getSsh() {
    return ssh;
  }

  private void setSsh(Session ssh) {
    this.ssh = ssh;
  }
}
