package com.devplatform.admin.config;

import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequestWrapper;


/**
 * 请求过滤xss
 *
 * @author Administrator
 */
public class MyHttpServletRequest extends HttpServletRequestWrapper {


  public MyHttpServletRequest(javax.servlet.http.HttpServletRequest servletRequest) {
    super(servletRequest);
  }

  @Override
  public String[] getParameterValues(String parameter) {
    String[] values = super.getParameterValues(parameter);
    if (values == null) {
      return null;
    }
    int count = values.length;
    String[] encodedValues = new String[count];
    for (int i = 0; i < count; i++) {
      encodedValues[i] = stripXss(values[i]);
    }
    return encodedValues;
  }

  @Override
  public String getParameter(String parameter) {
    String value = super.getParameter(parameter);
    return stripXss(value);
  }

  @Override
  public String getHeader(String name) {
    String value = super.getHeader(name);
    return stripXss(value);
  }

  private String stripXss(String value) {
    if (value != null) {
      value = value.replaceAll("", "");
      String scriptStr = "<script>(.*?)</script>";
      Pattern scriptPattern = Pattern.compile(scriptStr, Pattern.CASE_INSENSITIVE);
      value = scriptPattern.matcher(value).replaceAll("");

      String scrStr = "src[\r\n]*=[\r\n]*\\\'(.*?)\\\'";
      scriptPattern = Pattern.compile(scrStr, Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
      value = scriptPattern.matcher(value).replaceAll("");

      String scrStr3 = "src[\r\n]*=[\r\n]*\\\"(.*?)\\\"";
      scriptPattern = Pattern.compile(scrStr3, Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
      value = scriptPattern.matcher(value).replaceAll("");

      String scrStr4 = "</script>";
      scriptPattern = Pattern.compile(scrStr4, Pattern.CASE_INSENSITIVE);
      value = scriptPattern.matcher(value).replaceAll("");

      String scrStr5 = "<script(.*?)>";
      scriptPattern = Pattern.compile(scrStr5, Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
      value = scriptPattern.matcher(value).replaceAll("");

      String scrStr6 = "eval\\((.*?)\\)";
      scriptPattern = Pattern.compile(scrStr6, Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
      value = scriptPattern.matcher(value).replaceAll("");

      String scrStr7 = "e­xpression\\((.*?)\\)";
      scriptPattern = Pattern.compile(scrStr7, Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
      value = scriptPattern.matcher(value).replaceAll("");

      String scrStr8 = "javascript:";
      scriptPattern = Pattern.compile(scrStr8, Pattern.CASE_INSENSITIVE);
      value = scriptPattern.matcher(value).replaceAll("");

      String scrStr9 = "vbscript:";
      scriptPattern = Pattern.compile(scrStr9, Pattern.CASE_INSENSITIVE);
      value = scriptPattern.matcher(value).replaceAll("");

      String scrStr10 = "onload(.*?)=";
      scriptPattern = Pattern.compile(scrStr10, Pattern.CASE_INSENSITIVE | Pattern.MULTILINE | Pattern.DOTALL);
      value = scriptPattern.matcher(value).replaceAll("");
    }
    return value;
  }
}
