package com.devplatform.admin.config;

import com.devplatform.admin.modules.sys.oauth2.Oauth2Filter;
import com.devplatform.admin.modules.sys.oauth2.Oauth2Realm;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.servlet.Filter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Shiro配置
 *
 * @author chenshun
 * @email sunlightcs@gmail.com
 * @date 2017-04-20 18:33
 */
@Configuration
public class ShiroConfig {

  @Bean("sessionManager")
  public SessionManager sessionManager() {
    DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
    // 会话过期时间，单位：毫秒(在无操作时开始计时) 默认30分钟，此处设置为2小时
    sessionManager.setGlobalSessionTimeout(1000 * 7200);
    sessionManager.setSessionValidationSchedulerEnabled(true);
    sessionManager.setSessionIdCookieEnabled(true);
    return sessionManager;
  }

  @Bean("securityManager")
  public SecurityManager securityManager(Oauth2Realm oAuth2Realm, SessionManager sessionManager) {
    DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
    securityManager.setRealm(oAuth2Realm);
    securityManager.setSessionManager(sessionManager);

    return securityManager;
  }

  @Bean("shiroFilter")
  public ShiroFilterFactoryBean shirFilter(SecurityManager securityManager) {
    ShiroFilterFactoryBean shiroFilter = new ShiroFilterFactoryBean();
    shiroFilter.setSecurityManager(securityManager);

    // oauth过滤
    Map<String, Filter> filters = new HashMap<>(32);
    filters.put("oauth2", new Oauth2Filter());
    shiroFilter.setFilters(filters);

    Map<String, String> filterMap = new LinkedHashMap<>();
    filterMap.put("/webjars/**", "anon");
    filterMap.put("/druid/**", "anon");
    filterMap.put("/sysSystem/getSystem", "anon");
    filterMap.put("/send/task/*", "anon");
    filterMap.put("/app/**", "anon");
    filterMap.put("/**/sys/login", "anon");
    filterMap.put("/**/sys/test", "anon");
    filterMap.put("/test/config/receiveToken", "anon");
    filterMap.put("/sys/user/infoByName/**", "anon");
    filterMap.put("/**/sys/login2", "anon");
    filterMap.put("/swagger/**", "anon");
    filterMap.put("/v2/api-docs", "anon");
    filterMap.put("/swagger-ui.html", "anon");
    filterMap.put("/doc.html", "anon");
    filterMap.put("/swagger-resources/**", "anon");
    filterMap.put("/captcha.jpg", "anon");
    filterMap.put("/websocket/**", "anon");
    filterMap.put("/push/**", "anon");
    filterMap.put("/eWarning/list", "anon");
    filterMap.put("/push/websocket", "anon");
    filterMap.put("/endpoint", "anon");
    filterMap.put("/weChat/**", "anon");
    filterMap.put("/equipment/sendParamsInfo", "anon");
    filterMap.put("/liStation/queryById", "anon");
    filterMap.put("/sysStationTakeover/anyRouter", "anon");
    filterMap.put("/kanban/export/toExcel", "anon");
    filterMap.put("/analysis/export/toExcelFx", "anon");
    filterMap.put("/**", "oauth2");
    shiroFilter.setFilterChainDefinitionMap(filterMap);

    return shiroFilter;
  }

  @Bean("lifecycleBeanPostProcessor")
  public LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
    return new LifecycleBeanPostProcessor();
  }

  @Bean
  public DefaultAdvisorAutoProxyCreator defaultAdvisorAutoProxyCreator() {
    DefaultAdvisorAutoProxyCreator proxyCreator = new DefaultAdvisorAutoProxyCreator();
    proxyCreator.setProxyTargetClass(true);
    return proxyCreator;
  }

  @Bean
  public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(
      SecurityManager securityManager) {
    AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
    advisor.setSecurityManager(securityManager);
    return advisor;
  }
}
